package cn.ibizlab.codegen.cmd;

import cn.ibizlab.codegen.templating.TemplateManager;
import io.airlift.airline.Command;
import io.airlift.airline.Option;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.StringUtils;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

@SuppressWarnings({"unused", "java:S106"})
@Command(name = "ls", description = "Show list information used in tooling")
public class ListCommand extends IbizLabGeneratorCommand {

    @Option(name = {"-n","--template-name"}, description = "sepc template list")
    private String template;

    @Option(name = {"-a","--all"}, description = "template list")
    private Boolean all;

    @Override
    public void execute() {
        List<String> retList = new ArrayList<>();

        if (!StringUtils.isEmpty(template)) {
            retList=getList("templ/"+template+"/**");
            retList.forEach(item->System.out.println(item));
        } else {
            retList=getList("templ/**");
            retList.forEach(item->System.out.println(item));
        }


    }

    private ResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver();


    public List<String> getList(String rootDir)  {
        List<String> list=new ArrayList<>();
        try
        {
            Resource[] resource=resourceResolver.getResources("classpath:"+rootDir);
            for(Resource file:resource)
            {
                if(file instanceof ClassPathResource)
                {
                    String path=((ClassPathResource)file).getPath();
                    String name=file.getFilename();
                    path=path.replaceAll("\\\\","/");
                    if(path.endsWith("/"))
                        continue;
                    path=path.substring(rootDir.length()-2);
                    list.add(path);
                }
                else if(file instanceof FileSystemResource)
                {
                    String path=((FileSystemResource)file).getPath();
                    String name=file.getFilename();
                    if(file.getFile().isDirectory())
                        continue;
                    path=path.replaceAll("\\\\","/");
                    String atStr="/modules/ibizlab-generator-core/target/classes/";
                    int at="/modules/ibizlab-generator-core/target/classes/".length()+rootDir.length()-2;
                    path=path.substring(path.indexOf(atStr)+at);
                    list.add(path);
                }

            }



        }catch (Exception ex){
            ex.printStackTrace();
        }

        return list;
    }

}
