package cn.ibizlab.codegen.model;

import cn.ibizlab.codegen.templating.TemplateDefinition;
import cn.ibizlab.codegen.templating.TemplateFileType;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.util.*;

@Getter
@Setter
@NoArgsConstructor
@Accessors(chain = true)
public class CliFilter {

    private Map<String,Set<String>> items=new HashMap<>();

    public CliFilter(List<String> exps)
    {
        if(!ObjectUtils.isEmpty(exps))
        {
            for(String exp:exps)
            {
                String[] pairs=exp.split(":");
                if(pairs.length==2)
                {
                    String key=pairs[0].trim();
                    String value=pairs[1].trim();
                    if((!StringUtils.isEmpty(key))&&(!StringUtils.isEmpty(value)))
                    {
                        String type="";
                        String subType="";
                        String[] types=key.split("@");
                        type=types[0].trim();
                        if(!StringUtils.isEmpty(type))
                        {
                            type = TemplateFileType.forTemplateType(type).name();
                            if(type==null)
                                continue;
                            key = type;
                            if(types.length>1) {
                                subType = types[1].trim().toLowerCase();
                                if(!StringUtils.isEmpty(subType))
                                    key=key+"@"+subType;
                            }

                            Set<String> sets = null;
                            if(!items.containsKey(key))
                            {
                                sets=new LinkedHashSet<>();
                                items.put(key,sets);
                            }
                            else {
                                sets=items.get(key);
                            }
                            sets.add(value);
                            LabelExt ext=new LabelExt(value);
                            sets.add(ext.toLowerCase());
                            sets.add(ext.toUpperCase());
                            sets.add(ext.toSpinalCase());
                            sets.add(ext.toCamelCase());
                            sets.add(ext.toPascalCase());
                            sets.add(ext.toSnakeCase());
                            sets.add(ext.toPluralize());
                        }

                    }
                }
            }

        }

    }

    public Set<String> getTypes()
    {
        Set<String> sets=new HashSet<>();
        if(!ObjectUtils.isEmpty(items))
        {
            items.keySet().forEach(key->{
                sets.add(key.split("@")[0]);
            });
        }
        return sets;
    }



}
