package cn.ibizlab.codegen.model;

import cn.ibizlab.codegen.utils.Inflector;
import cn.ibizlab.codegen.utils.StringAdvUtils;
import org.springframework.util.StringUtils;

import java.util.stream.IntStream;

public class LabelExt implements java.io.Serializable, Comparable<String>, CharSequence {
    private String label="";
    public LabelExt(String label)
    {
        if(!StringUtils.isEmpty(label))
            this.label=label;
    }

    public String toLowerCase()
    {
        return label.toLowerCase();
    }

    public String toUpperCase()
    {
        return label.toUpperCase();
    }

    public String toPascalCase() {
        return StringAdvUtils.pascalcase(label);
    }

    public String toCapFirst() {
        return StringAdvUtils.pascalcase(label);
    }

    public String toCamelCase() {
        return StringAdvUtils.camelcase(label);
    }

    public String toSpinalCase() {
        return StringAdvUtils.spinalcase(label);
    }

    public String toSnakeCase() {
        return StringAdvUtils.snakecase(label);
    }

    public String toPluralize() {
        return Inflector.getInstance().pluralize(toCamelCase());
    }

    public String getLowerCase()
    {
        return toLowerCase();
    }

    public String getUpperCase()
    {
        return toUpperCase();
    }

    public String getPascalCase() {
        return toPascalCase();
    }

    public String getCapFirst() {
        return toCapFirst();
    }

    public String getCamelCase() {
        return toCamelCase();
    }

    public String getSpinalCase() {
        return toSpinalCase();
    }

    public String getSnakeCase() {
        return toSnakeCase();
    }

    public String getPluralize() {
        return toPluralize();
    }


    @Override
    public int length() {
        return label.length();
    }

    @Override
    public char charAt(int index) {
        return label.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return label.subSequence(start,end);
    }

    @Override
    public String toString() {
        return label;
    }

    @Override
    public IntStream chars() {
        return label.chars();
    }

    @Override
    public IntStream codePoints() {
        return label.codePoints();
    }

    @Override
    public int compareTo(String o) {
        return label.compareTo(o);
    }

    public int compareToIgnoreCase(String o) {
        return label.compareToIgnoreCase(o);
    }

    public boolean startsWith(String prefix) {
        return label.startsWith(prefix);
    }

    public boolean endsWith(String suffix) {
        return label.endsWith(suffix);
    }

    public int indexOf(int ch) {
        return label.indexOf(ch, 0);
    }

    public String substring(int beginIndex) {
        return label.substring(beginIndex);
    }

    public String substring(int beginIndex,int endIndex) {
        return label.substring(beginIndex,endIndex);
    }

    public String replace(char oldChar, char newChar) {
        return label.replace(oldChar,newChar);
    }
}
