package cn.ibizlab.codegen.model;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import net.ibizsys.model.dataentity.ds.IPSDEDataSet;

/**
 * 实体[数据集]
 */
@Getter
@Setter
@NoArgsConstructor
@Accessors(chain = true)
public class DataSetModel extends BaseModel{

    public DataSetModel(EntityModel entityModel,IPSDEDataSet dataSet)
    {
        this.opt=dataSet;
        this.entity=entityModel;
        this.setCodeName(dataSet.getCodeName());
        this.setName(dataSet.getName());
        this.setId(String.format("%1$s-%2$s",entity.getCodeName(),dataSet.getCodeName()));
    }

    private EntityModel entity;

    /**
     * 标识
     */
    private String datasetId;
    /**
     * 名称
     */
    private String datasetName;

    @Override
    public DataSetModel setCodeName(String codeName) {
        super.setCodeName(codeName);
        this.setId(String.format("%1$s-%2$s",entity.getCodeName(),codeName));
        return this;
    }
    /**
     * 代码
     */
    private String dsCode;
    /**
     * SQL
     */
    private String dsModel;

    public IPSDEDataSet getDataSet()
    {
        return (IPSDEDataSet)opt;
    }

}


