package cn.ibizlab.codegen.templating.mustache;

import cn.ibizlab.codegen.CodegenConfig;
import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;

import java.io.IOException;
import java.io.Writer;

/**
 * Split text by 2 spaces and then join the strings with ", "
 *
 * Register:
 * <pre>
 * additionalProperties.put("joinWithComma", new JoinWithCommaLambda());
 * </pre>
 *
 * Use:
 * <pre>
 * {{#joinWithComma}}{{name}}{{/joinWithComma}}
 * </pre>
 */
public class JoinWithCommaLambda implements Mustache.Lambda {
    private CodegenConfig generator = null;

    public JoinWithCommaLambda() {

    }

    public JoinWithCommaLambda generator(final CodegenConfig generator) {
        this.generator = generator;
        return this;
    }

    @Override
    public void execute(Template.Fragment fragment, Writer writer) throws IOException {
        String[] substr = fragment.execute().trim().split("  ");

        writer.write(String.join(", ", substr));
    }
}
