package cn.ibizlab.codegen.model;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import net.ibizsys.model.app.view.IPSAppView;
import net.ibizsys.model.control.IPSControl;
import net.ibizsys.model.control.expbar.IPSExpBar;
import net.ibizsys.model.control.toolbar.IPSDETBUIActionItem;
import net.ibizsys.model.control.toolbar.IPSDEToolbar;
import net.ibizsys.model.view.IPSUIAction;

import java.util.*;

@Getter
@Setter
@NoArgsConstructor
@Accessors(chain = true)
public class PageModel extends BaseModel{

    public PageModel(AppModel appModel,IPSAppView appView)
    {
        this.opt=appView;
        this.app=appModel;
        this.setCodeName(appView.getCodeName());
        this.setName(appView.getName());
        this.setId(String.format("%1$s-%2$s",app.getCodeName(),appView.getCodeName()));

        if(appView.getPSAppDataEntity()!=null)
            this.appEntity=app.getAppEntity(appView.getPSAppDataEntity().getCodeName());

        if(appView.getPSControls()!=null)
        {
            appView.getPSControls().forEach(item->{
                CtrlModel ctrl=new CtrlModel(appModel,item);
                if(!this.app.getCtrlsMap().containsKey(ctrl.getId()))
                {
                    if(ctrl.getControl().getPSAppDataEntity()!=null) {
                        AppEntityModel ctrlAppEntity=app.getAppEntity(ctrl.getControl().getPSAppDataEntity().getCodeName());
                        ctrl.setAppEntity(ctrlAppEntity);
                        ctrlAppEntity.addCtrl(ctrl.getId(),ctrl);
                    }
                    this.app.getCtrlsMap().put(ctrl.getId(),ctrl);
                }
                this.ctrlsMap.put(ctrl.getId(),ctrl);
                //  树导航栏获取数据部件
                if ("TREEEXPBAR".equals(ctrl.getControl().getControlType())) {
                    List<IPSControl> controls = ((IPSExpBar)item).getPSControls();
                    if (controls.size() > 0) {
                        for (IPSControl control : controls) {
                            CtrlModel ctrlModel = new CtrlModel(appModel, control);
                            if(ctrlModel.getControl().getPSAppDataEntity()!=null) {
                                AppEntityModel ctrlAppEntity = app.getAppEntity(ctrlModel.getControl().getPSAppDataEntity().getCodeName());
                                ctrlModel.setAppEntity(ctrlAppEntity);
                                ctrlAppEntity.addCtrl(ctrlModel.getId(), ctrlModel);
                            }
                            ctrl.addCtrl(ctrlModel.getCodeName().toString(), ctrlModel);
                            if(!this.app.getCtrlsMap().containsKey(ctrlModel.getId())) {
                                this.app.getCtrlsMap().put(ctrlModel.getId(),ctrlModel);
                            }
                        }
                    }
                }
            });
        }
        // 初始化工具栏数据
        if(appView.getPSControls() != null)
        {
            appView.getPSControls().forEach(item->{
               if("TOOLBAR".equals(item.getControlType())){
                    JSONObject viewToolBar = new JSONObject();
                    viewToolBar.put("codeName",item.getCodeName());
                    viewToolBar.put("controlType",item.getControlType());
                    viewToolBar.put("logicName",item.getLogicName());
                    if(((IPSDEToolbar)item).getPSDEToolbarItems() != null){
                        JSONArray items = new JSONArray();
                        ((IPSDEToolbar)item).getPSDEToolbarItems().forEach(singleItam ->{
                            JSONObject toolbarItem = new JSONObject();
                            toolbarItem.put("caption",singleItam.getCaption());
                            if(singleItam.getCapPSLanguageRes() != null && singleItam.getCapPSLanguageRes().getLanResTag() != null){
                                toolbarItem.put("capPSLanguageRes",singleItam.getCapPSLanguageRes().getLanResTag());
                            }
                            toolbarItem.put("tooltip",singleItam.getTooltip());
                            if(singleItam.getTooltipPSLanguageRes() != null && singleItam.getTooltipPSLanguageRes().getLanResTag() != null){
                                toolbarItem.put("tooltipPSLanguageRes",singleItam.getTooltipPSLanguageRes().getLanResTag());
                            }
                            toolbarItem.put("itemType",singleItam.getItemType());
                            toolbarItem.put("name",singleItam.getName());
                            toolbarItem.put("showCaption",singleItam.isShowCaption());
                            toolbarItem.put("showIcon",singleItam.isShowIcon());
                            if(singleItam.getPSSysImage() != null && singleItam.getPSSysImage().getCssClass() != null){
                                toolbarItem.put("iconClass",singleItam.getPSSysImage().getCssClass());
                            }
                            if(singleItam.getPSSysImage() != null && singleItam.getPSSysImage().getImagePath() != null){
                                toolbarItem.put("imgPath",singleItam.getPSSysImage().getImagePath());
                            }
                            if("DEUIACTION".equals(singleItam.getItemType())){
                                IPSDETBUIActionItem actionItem = (IPSDETBUIActionItem)singleItam;
                                toolbarItem.put("groupExtractMode",actionItem.getNoPrivDisplayMode());
                                toolbarItem.put("noPrivDisplayMode",actionItem.getNoPrivDisplayMode());
                                toolbarItem.put("id",actionItem.getPSAppViewUIAction().getId());
                                toolbarItem.put("xDataControlName",actionItem.getPSAppViewUIAction().getXDataControlName());
                                if(actionItem.getPSAppViewUIAction().getPSUIAction() != null){
                                    IPSUIAction UIAction = actionItem.getPSAppViewUIAction().getPSUIAction();
                                    JSONObject appUIAction = new JSONObject();
                                    appUIAction.put("caption",UIAction.getCaption());
                                    if(UIAction.getCapPSLanguageRes() != null && UIAction.getCapPSLanguageRes().getLanResTag() != null){
                                        appUIAction.put("capPSLanguageRes",UIAction.getCapPSLanguageRes().getLanResTag());
                                    }
                                    appUIAction.put("codeName",UIAction.getCodeName());
                                    appUIAction.put("fullCodeName",UIAction.getFullCodeName());
                                    appUIAction.put("name",UIAction.getName());
                                    appUIAction.put("uIActionMode",UIAction.getUIActionMode());
                                    appUIAction.put("uIActionTag",UIAction.getUIActionTag());
                                    appUIAction.put("uIActionType",UIAction.getUIActionType());
                                    toolbarItem.put("uIAction",appUIAction);
                                }
                            }
                            items.add(toolbarItem);
                        });
                        viewToolBar.put("items",items);
                    }
                   toolBarItems.add(viewToolBar);
               }
            });
        }

    }

    public IPSAppView getAppView()
    {
        return (IPSAppView)opt;
    }

    private AppModel app;

    private AppEntityModel appEntity;

    public LabelExt getAppModule()
    {
        String appModules="default";
        if(getAppView().getPSAppModule()!=null)
            appModules=getAppView().getPSAppModule().getCodeName();

        return new LabelExt(appModules);
    }

    private Map<String,CtrlModel> ctrlsMap=new LinkedHashMap<>();

    public Collection<CtrlModel> getCtrls(){
        return ctrlsMap.values();
    }

    private Collection<JSONObject> toolBarItems = new ArrayList<>();

    public Collection<JSONObject> getViewToolBarItems(){
        return toolBarItems;
    }

}
