package cn.ibizlab.codegen.model;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import net.ibizsys.model.dataentity.service.IPSDEMethodDTO;
import net.ibizsys.model.dataentity.service.IPSDEServiceAPI;
import net.ibizsys.model.dataentity.service.IPSDEServiceAPIMethod;
import net.ibizsys.model.dataentity.service.IPSDEServiceAPIRS;

import java.util.ArrayList;
import java.util.List;

@Getter
@Setter
@NoArgsConstructor
@Accessors(chain = true)
public class ApiEntityRSModel extends BaseModel {

    public ApiEntityRSModel(ApiModel apiModel, IPSDEServiceAPIRS iPSDEServiceAPIRS) {
        this.opt = iPSDEServiceAPIRS;
        this.api = apiModel;
        this.setCodeName(iPSDEServiceAPIRS.getCodeName());
        this.setName(iPSDEServiceAPIRS.getName());
    }

    private ApiModel api;

    public String getParentIdFieldCodeName() {
        if (getPSDEServiceAPIRS().getParentIdPSDEField() != null)
            return getPSDEServiceAPIRS().getParentIdPSDEField().getCodeName();
        return "";
    }

    public int getParentIdFieldType() {
        if (getPSDEServiceAPIRS().getParentIdPSDEField() != null)
            return getPSDEServiceAPIRS().getParentIdPSDEField().getStdDataType();
        return PropType.VARCHAR.code;
    }

    public String getMajorEntityCodeName() {
        return getPSDEServiceAPIRS().getMajorPSDEServiceAPI().getCodeName();
    }

    public boolean isMajorEntityMajor() {
        return getPSDEServiceAPIRS().getMajorPSDEServiceAPI().isMajor();
    }


    public String getMinorEntityCodeName() {
        return getPSDEServiceAPIRS().getMinorPSDEServiceAPI().getCodeName();
    }


    private IPSDEServiceAPIRS getPSDEServiceAPIRS() {
        return (IPSDEServiceAPIRS) opt;
    }
}
