package cn.ibizlab.codegen.model;

import cn.ibizlab.codegen.utils.StringAdvUtils;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import net.ibizsys.model.app.wf.IPSAppWFVer;
import net.ibizsys.model.dataentity.action.IPSDEAction;
import net.ibizsys.model.dataentity.action.IPSDELogicAction;
import net.ibizsys.model.dataentity.action.IPSDEScriptAction;
import net.ibizsys.model.wf.*;
import org.springframework.util.DigestUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.util.*;

@Getter
@Setter
@NoArgsConstructor
@Accessors(chain = true)
public class WorkflowModel extends BaseModel{

    public WorkflowModel(SystemModel systemModel, IPSWorkflow psWorkflow,IPSWFVersion ver)
    {
        this.opt=ver;
        this.system=systemModel;
        this.psWorkflow=psWorkflow;
        this.setCodeName(ver.getCodeName());
        this.setName(ver.getName());
        this.setId(String.format("%1$s-%2$s",system.getCodeName().toLowerCase(),ver.getCodeName().toLowerCase()));

    }

    public IPSWFVersion getWFVer()
    {
        return (IPSWFVersion)opt;
    }

    private IPSWorkflow psWorkflow;


    private SystemModel system;

    private Map<String,IPSWFProcessRole> refGroups;
    public Map<String,IPSWFProcessRole> getRefGroups()
    {
        if(refGroups==null)
        {
            refGroups=new LinkedHashMap<>();
            if(!ObjectUtils.isEmpty(getWFVer().getPSWFProcesses()))
            {
                getWFVer().getPSWFProcesses().forEach(WFProcess->{
                    List<IPSWFProcessRole> roles=null;
                    if(WFProcess instanceof IPSWFInteractiveProcess)
                        roles=((IPSWFInteractiveProcess) WFProcess).getPSWFProcessRoles();
                    else if(WFProcess instanceof IPSWFCallOrgActivityProcess)
                        roles=((IPSWFCallOrgActivityProcess) WFProcess).getPSWFProcessRoles();
                    if(!ObjectUtils.isEmpty(roles))
                    {
                        roles.forEach(role->{
                            if(!"WFROLE".equalsIgnoreCase(role.getWFProcessRoleType()))
                                return;
                            String roleId=role.getPSWFRole().getCodeName()+"|"+role.getPSWFRole().getName()+"|"+role.getPSWFRole().getWFRoleType();
                            if("DEDATASET".equalsIgnoreCase(role.getPSWFRole().getWFRoleType())&&role.getPSWFRole() instanceof IPSWFDEDataSetRole) {
                                IPSWFDEDataSetRole dsRole=(IPSWFDEDataSetRole)role.getPSWFRole();
                                if(dsRole.getWFUserIdPSDEF()!=null&&dsRole.getPSDEDataSet()!=null&&dsRole.getPSDataEntity()!=null)
                                    roleId += ("/" + StringAdvUtils.pluralize(dsRole.getPSDataEntity().getCodeName())+"/fetch"+dsRole.getPSDEDataSet().getCodeName().toLowerCase()+"."+dsRole.getWFUserIdPSDEF().getCodeName().toLowerCase());
                            }
                            refGroups.put(roleId,role);
                        });
                    }

                });
            }
        }
        return refGroups;
    }


    private Map<String,EntityModel> bookings;
    public Map<String,EntityModel> getBookings()
    {
        if(getPsWorkflow()!=null&&getPsWorkflow().getPSWFDEs()!=null)
        {
            if(bookings==null)
            {
                bookings=new LinkedHashMap<>();
                getPsWorkflow().getPSWFDEs().forEach(de->{
                    if(de.getPSDataEntity()==null)
                        return;
                    bookings.put(de.getPSDataEntity().getCodeName(),getSystem().getEntity(de.getPSDataEntity().getCodeName()));
                });
            }
        }

        return bookings;
    }


    private Map<String,Map<String,AppModel>> mobApps;
    public Map<String,Map<String,AppModel>> getMobApps() {
        if (mobApps == null&&getBookings()!=null) {
            mobApps=new LinkedHashMap<>();
            getBookings().keySet().forEach(entity->{
                if(ObjectUtils.isEmpty(getSystem().getApps()))
                    return;
                getSystem().getApps().forEach(app->{
                    if(!app.getApplication().isMobileApp())
                        return;
                    if(ObjectUtils.isEmpty(app.getAppEntities()))
                        return;
                    for(AppEntityModel appEntity:app.getAppEntities())
                    {
                        if(appEntity.getEntity()!=null&&entity.equalsIgnoreCase(appEntity.getEntity().getCodeName()))
                        {
                            Map<String,AppModel> refApps=null;
                            if(mobApps.containsKey(appEntity.getEntity().getCodeName()))
                                refApps=mobApps.get(appEntity.getEntity().getCodeName());
                            else
                            {
                                refApps=new LinkedHashMap<>();
                                mobApps.put(appEntity.getEntity().getCodeName(),refApps);
                            }
                            refApps.put(app.codeName,app);
                            return;
                        }
                    }
                });
            });
        }
        return mobApps;
    }

    private Map<String,Map<String,AppModel>> webApps;
    public Map<String,Map<String,AppModel>> getWebApps() {
        if (webApps == null&&getBookings()!=null) {
            webApps=new LinkedHashMap<>();
            getBookings().keySet().forEach(entity->{
                if(ObjectUtils.isEmpty(getSystem().getApps()))
                    return;
                getSystem().getApps().forEach(app->{
                    if(app.getApplication().isMobileApp())
                        return;
                    if(ObjectUtils.isEmpty(app.getAppEntities()))
                        return;
                    for(AppEntityModel appEntity:app.getAppEntities())
                    {
                        if(appEntity.getEntity()!=null&&entity.equalsIgnoreCase(appEntity.getEntity().getCodeName()))
                        {
                            Map<String,AppModel> refApps=null;
                            if(webApps.containsKey(appEntity.getEntity().getCodeName()))
                                refApps=webApps.get(appEntity.getEntity().getCodeName());
                            else
                            {
                                refApps=new LinkedHashMap<>();
                                webApps.put(appEntity.getEntity().getCodeName(),refApps);
                            }
                            refApps.put(app.codeName,app);
                            return;
                        }
                    }
                });
            });
        }
        return webApps;
    }

    private List<Map> userTasks;

    public List<Map> getUserTasks()
    {
        if(getWFVer().getPSWFProcesses()!=null)
        {
            userTasks=new ArrayList<>();

            getWFVer().getPSWFProcesses().forEach(WFProcess->{
                if(!isUserTask(WFProcess))
                    return;

                Map<String,Object> map=new HashMap<>();
                map.put("process",WFProcess);
                List<IPSWFProcessRole> roles=null;
                List<String> formParam=new ArrayList<>();
                boolean multiInstanceLoopCharacteristics=false;
                if(WFProcess instanceof IPSWFInteractiveProcess)
                {
                    IPSWFInteractiveProcess  interactiveProcess=(IPSWFInteractiveProcess)WFProcess;
                    if("SEQUENTIAL".equalsIgnoreCase(interactiveProcess.getMultiInstMode())) {
                        map.put("sequential", true);
                        multiInstanceLoopCharacteristics=true;
                    }
                    else if("PARALLEL".equalsIgnoreCase(interactiveProcess.getMultiInstMode())) {
                        map.put("sequential", false);
                        multiInstanceLoopCharacteristics=true;
                    }
                    map.put("multiInstanceLoopCharacteristics",multiInstanceLoopCharacteristics);
                    roles=interactiveProcess.getPSWFProcessRoles();
                    map.put("hasForm",(!StringUtils.isEmpty(interactiveProcess.getFormCodeName()))||(!StringUtils.isEmpty(interactiveProcess.getMobFormCodeName())));

                    if(!ObjectUtils.isEmpty(interactiveProcess.getPredefinedActions()))
                    {
                        formParam.add("procfunc=\""+String.join(";",interactiveProcess.getPredefinedActions()).toLowerCase()+"\"");
                    }
                    if(!StringUtils.isEmpty(interactiveProcess.getFormCodeName()))
                        formParam.add("process-form=\""+interactiveProcess.getFormCodeName()+"\" ");
                    if(!StringUtils.isEmpty(interactiveProcess.getMobFormCodeName()))
                        formParam.add("process-mobform=\""+interactiveProcess.getMobFormCodeName()+"\" ");
                    if(!StringUtils.isEmpty(interactiveProcess.getUtilFormCodeName()))
                        formParam.add("process-utilform=\""+interactiveProcess.getUtilFormCodeName()+"\" " +
                                "process-utilformname=\""+(StringUtils.isEmpty(interactiveProcess.getUtilFormName())?interactiveProcess.getUtilFormCodeName():interactiveProcess.getUtilFormName())+"\" ");
                    if(!StringUtils.isEmpty(interactiveProcess.getUtil2FormCodeName()))
                        formParam.add("process-util2form=\""+interactiveProcess.getUtil2FormCodeName()+"\" " +
                                "process-util2formname=\""+(StringUtils.isEmpty(interactiveProcess.getUtil2FormName())?interactiveProcess.getUtil2FormCodeName():interactiveProcess.getUtil2FormName())+"\" ");
                    if(!StringUtils.isEmpty(interactiveProcess.getUtil3FormCodeName()))
                        formParam.add("process-util3form=\""+interactiveProcess.getUtil3FormCodeName()+"\" " +
                                "process-util3formname=\""+(StringUtils.isEmpty(interactiveProcess.getUtil3FormName())?interactiveProcess.getUtil3FormCodeName():interactiveProcess.getUtil3FormName())+"\" ");

                    if(!StringUtils.isEmpty(interactiveProcess.getMobUtilFormCodeName()))
                        formParam.add("process-mobutilform=\""+interactiveProcess.getMobUtilFormCodeName()+"\" " +
                                "process-mobutilformname=\""+(StringUtils.isEmpty(interactiveProcess.getMobUtilFormName())?interactiveProcess.getMobUtilFormCodeName():interactiveProcess.getMobUtilFormName())+"\" ");
                    if(!StringUtils.isEmpty(interactiveProcess.getMobUtil2FormCodeName()))
                        formParam.add("process-mobutil2form=\""+interactiveProcess.getMobUtil2FormCodeName()+"\" " +
                                "process-mobutil2formname=\""+(StringUtils.isEmpty(interactiveProcess.getMobUtil2FormName())?interactiveProcess.getMobUtil2FormCodeName():interactiveProcess.getMobUtil2FormName())+"\" ");
                    if(!StringUtils.isEmpty(interactiveProcess.getMobUtil3FormCodeName()))
                        formParam.add("process-mobutil3form=\""+interactiveProcess.getMobUtil3FormCodeName()+"\" " +
                                "process-mobutil3formname=\""+(StringUtils.isEmpty(interactiveProcess.getMobUtil3FormName())?interactiveProcess.getMobUtil3FormCodeName():interactiveProcess.getMobUtil3FormName())+"\" ");

                    String userTag="";
                    if(!StringUtils.isEmpty(interactiveProcess.getUserData()))
                        userTag=interactiveProcess.getUserData();
                    if(!StringUtils.isEmpty(interactiveProcess.getUserData2())) {
                        if(!StringUtils.isEmpty(userTag))
                            userTag+="|";
                        userTag += interactiveProcess.getUserData2();
                    }
                    if(!StringUtils.isEmpty(userTag))
                        formParam.add("usertag=\""+userTag+"\" ");
                    if(interactiveProcess.isEditable()) {
                        formParam.add("isEditable=\"" + interactiveProcess.isEditable() + "\" ");
                        formParam.add("editMode=\"" + interactiveProcess.getEditMode() + "\" ");
                    }

                    if(!ObjectUtils.isEmpty(interactiveProcess.getEditFields()))
                    {
                        formParam.add("editFields=\""+String.join(";",interactiveProcess.getEditFields()).toLowerCase()+"\"");
                    }

                    if(interactiveProcess.isSendInform()&&interactiveProcess.getPSSysMsgTempl()!=null)
                        formParam.add("msg-template=\""+interactiveProcess.getPSSysMsgTempl().getCodeName().toLowerCase()+"\" , msg-type=\""+interactiveProcess.getMsgType()+"\" " );

                }
                else if(WFProcess instanceof IPSWFCallOrgActivityProcess) {
                    roles = ((IPSWFCallOrgActivityProcess) WFProcess).getPSWFProcessRoles();
                }
                if(!ObjectUtils.isEmpty(roles))
                {
                    List<String> assignCond=new ArrayList<>();
                    List<String> assignUtCond=new ArrayList<>();
                    List<String> assignGroupCond=new ArrayList<>();
                    roles.forEach(processRole-> {
                        if ("WFROLE".equalsIgnoreCase(processRole.getWFProcessRoleType())) {
                            String roleId=processRole.getPSWFRole().getCodeName();
                            if((!StringUtils.isEmpty(processRole.getUserData()))&&(!StringUtils.isEmpty(processRole.getUserData2())))
                                roleId=roleId+"|"+processRole.getUserData()+"|"+processRole.getUserData2();
                            assignGroupCond.add(roleId);
                        }
                        else if ("CURACTOR".equalsIgnoreCase(processRole.getWFProcessRoleType())) {
                            assignCond.add("${activedata.createman}");
                            assignUtCond.add("#activedata.createman");
                        }
                        else if(!StringUtils.isEmpty(processRole.getUDField()))
                        {
                            for(String str:processRole.getUDField().toLowerCase().split(";|,|；|，"))
                            {
                                assignCond.add("${activedata."+str+"}");
                                assignUtCond.add("#activedata."+str);
                            }

                        }
                    });
                    if(!ObjectUtils.isEmpty(assignGroupCond))
                    {
                        String strAssignGroupCond=String.join(",",assignGroupCond);
                        assignCond.add("${wfCoreService.getGroupUsers('"+strAssignGroupCond+"',execution)}");
                        map.put("assignGroupCond",strAssignGroupCond);
                        map.put("assignCond", String.join(",", assignCond));


                        String strAssignUtCond="";
                        if(!ObjectUtils.isEmpty(assignUtCond))
                            strAssignUtCond=String.join("|", assignUtCond)+"||";
                        strAssignUtCond+=("#wfCoreService.getGroupUsers2('"+strAssignGroupCond+"',#execution)");
                        map.put("assignUtCond", strAssignUtCond);
                    }
                    else if(!ObjectUtils.isEmpty(assignCond)) {
                        map.put("assignCond", String.join(",", assignCond));
                        if(!ObjectUtils.isEmpty(assignUtCond))
                            map.put("assignUtCond", String.join("|", assignUtCond));
                    }
                    if(multiInstanceLoopCharacteristics&&formParam.size()>0&&map.containsKey("assignUtCond")) {
                        formParam.add("candidateUsersList=\""+map.get("assignUtCond")+"\" ");
                    }
                }
                if(WFProcess.isEnableTimeout())
                {

                    String timeUnit="";
                    String timeType="";
                    if("MINUTE".equalsIgnoreCase(WFProcess.getTimeoutType()))
                    {
                        timeUnit="M";timeType="PT";
                    }
                    else if("HOUR".equalsIgnoreCase(WFProcess.getTimeoutType()))
                    {
                        timeUnit="H";timeType="PT";
                    }
                    else if("DAY".equalsIgnoreCase(WFProcess.getTimeoutType()))
                    {
                        timeUnit="D";timeType="P";
                    }
                    if(!ObjectUtils.isEmpty(WFProcess.getPSWFLinks()))
                    {
                        boolean timeOut = false;
                        for(IPSWFLink WFLink:WFProcess.getPSWFLinks()){
                            if(WFLink.getWFLinkType().equalsIgnoreCase("TIMEOUT"))
                            {
                                timeOut=true;
                            }
                        }
                        if(timeOut)
                        {
                            map.put("timeOut",true);
                            map.put("timeoutStrategy",timeType + WFProcess.getTimeout() + timeUnit);
                        }
                    }
                }

                if(formParam.size()>0) {

                    map.put("formParam", formParam);
                }

                userTasks.add(map);
            });
        }
        return userTasks;
    }

    private List<Map> processes;

    public List<Map> getProcesses()
    {
        if(processes==null) {
            if(getWFVer().getPSWFProcesses()!=null)
            {
                processes = new ArrayList<>();
                getWFVer().getPSWFProcesses().forEach(WFProcess-> {
                    Map<String,Object> map=new HashMap<>();
                    map.put("process",WFProcess);
                    if (!isUserTask(WFProcess))
                        map.put("processId","sid-"+WFProcess.getCodeName());
                    else
                        map.put("processId","tid-"+WFProcess.getWFStepValue()+"-"+WFProcess.getCodeName());
                    processes.add(map);
                });
            }
        }
        return processes;
    }

    private List<Map> sequenceFlows;

    public List<Map> getSequenceFlows()
    {
        if(sequenceFlows==null)
        {
            sequenceFlows=new ArrayList<>();
            if(!ObjectUtils.isEmpty(getWFVer().getPSWFLinks()))
            {
                getWFVer().getPSWFLinks().forEach(WFLink->{
                    Map<String,Object> map=new HashMap<>();
                    map.put("link",WFLink);

                    IPSWFProcess sourceProcess=WFLink.getFromPSWFProcess();
                    IPSWFProcess targetProcess=WFLink.getToPSWFProcess();
                    String sourceProcessId="sid-"+sourceProcess.getCodeName();
                    if(isUserTask(sourceProcess))
                        sourceProcessId="tid-"+sourceProcess.getWFStepValue()+"-"+sourceProcess.getCodeName();
                    String targetProcessId="sid-"+targetProcess.getCodeName();
                    if(isUserTask(targetProcess))
                        targetProcessId="tid-"+targetProcess.getWFStepValue()+"-"+targetProcess.getCodeName();
                    String linkDeployId= DigestUtils.md5DigestAsHex((sourceProcessId+sourceProcessId).getBytes());
                    String flowId="rid-"+linkDeployId;
                    if(!"ROUTE".equals(WFLink.getWFLinkType()))
                        flowId="lid-"+WFLink.getName()+"-"+linkDeployId;

                    map.put("sourceProcessId",sourceProcessId);
                    map.put("targetProcessId",targetProcessId);
                    map.put("flowId",flowId);
                    List<String> linkParam=new ArrayList<>();
                    if(WFLink instanceof PSWFInteractiveLinkImpl)
                    {
                        PSWFInteractiveLinkImpl interactiveLink=(PSWFInteractiveLinkImpl)WFLink;
                        if(!StringUtils.isEmpty(interactiveLink.getFormCodeName()))
                            linkParam.add("sequenceFlowForm=\""+interactiveLink.getFormCodeName()+"\" ");
                        if(!StringUtils.isEmpty(interactiveLink.getMobFormCodeName()))
                            linkParam.add("sequenceFlowMobForm=\""+interactiveLink.getMobFormCodeName()+"\" ");
                        if(!StringUtils.isEmpty(interactiveLink.getViewCodeName()))
                            linkParam.add("sequenceFlowView=\""+interactiveLink.getViewCodeName()+"\" ");
                        if(!StringUtils.isEmpty(interactiveLink.getMobViewCodeName()))
                            linkParam.add("sequenceFlowMobView=\""+interactiveLink.getMobViewCodeName()+"\" ");
                        if(!StringUtils.isEmpty(interactiveLink.getNextCondition()))
                            linkParam.add("nextCondition=\""+interactiveLink.getNextCondition()+"\" ");
                        if(!StringUtils.isEmpty(interactiveLink.getCustomCond()))
                            linkParam.add("customCond=\""+interactiveLink.getCustomCond()+"\" ");
                    }
                    if(linkParam.size()>0)
                        map.put("linkParam",linkParam);
                    if(!"TIMEOUT".equalsIgnoreCase(WFLink.getWFLinkType()))
                    {
                        if(!"Start001".equalsIgnoreCase(sourceProcess.getCodeName()))
                        {
                            String LinkCond="";
                            if("ROUTE".equalsIgnoreCase(WFLink.getWFLinkType()))
                            {
                                if(!StringUtils.isEmpty(WFLink.getCustomCond()))
                                    LinkCond=WFLink.getCustomCond();
                                else if( WFLink.getPSWFLinkGroupCond()!=null)
                                {
                                    LinkCond="<![CDATA[${"+getGroupCond(WFLink.getPSWFLinkGroupCond())+"} ]]>";
                                }
                            }
                            else
                                LinkCond="<![CDATA[${sequenceFlowId==\""+flowId+"\"}]]>";
                            if(!StringUtils.isEmpty(LinkCond))
                                map.put("linkCond",LinkCond);
                        }
                    }

                    sequenceFlows.add(map);
                });
            }
        }
        return sequenceFlows;
    }

    private boolean isUserTask(IPSWFProcess WFProcess)
    {
        String WFProcessType=WFProcess.getWFProcessType();
        return  !("START".equals(WFProcessType)||"END".equals(WFProcessType)||"PARALLELGATEWAY".equals(WFProcessType)||"INCLUSIVEGATEWAY".equals(WFProcessType)||"EXCLUSIVEGATEWAY".equals(WFProcessType)||"PROCESS".equals(WFProcessType));
    }

    private String getGroupCond(IPSWFLinkGroupCond WFLinkCond)
    {
        String strRuleCond="(";
        if(!ObjectUtils.isEmpty(WFLinkCond.getPSWFLinkConds()))
        {
            String conn=WFLinkCond.getGroupOP().replace("AND","&&").replace("OR","||");
            for(IPSWFLinkCond childWFLinkCond:WFLinkCond.getPSWFLinkConds())
            {
                String childLinkType=childWFLinkCond.getCondType();
                if ( childWFLinkCond instanceof IPSWFLinkGroupCond && (!ObjectUtils.isEmpty(((IPSWFLinkGroupCond)childWFLinkCond).getPSWFLinkConds())) ) {
                    if(!strRuleCond.equalsIgnoreCase("("))
                        strRuleCond=strRuleCond+conn;
                    strRuleCond = strRuleCond + getGroupCond((IPSWFLinkGroupCond) childWFLinkCond);
                }
                else if(childWFLinkCond instanceof IPSWFLinkSingleCond ) {
                    if(!strRuleCond.equalsIgnoreCase("("))
                        strRuleCond=strRuleCond+conn;
                    strRuleCond = strRuleCond + getFieldCond((IPSWFLinkSingleCond) childWFLinkCond);
                }

            }
        }
        strRuleCond=strRuleCond+")";
        return strRuleCond;
    }

    private String getFieldCond(IPSWFLinkSingleCond WFLinkCond)
    {
        String fieldCond="(";
        String condBody="";
        String paramType=WFLinkCond.getParamType()==null?"":WFLinkCond.getParamType();
        String targetField=WFLinkCond.getFieldName()==null?"":WFLinkCond.getFieldName().toLowerCase();
        String targetDBValueOP=WFLinkCond.getCondType();
        String targetValue=WFLinkCond.getParamValue();
        if("ISNULL".equalsIgnoreCase(targetDBValueOP)||"ISNOTNULL".equalsIgnoreCase(targetDBValueOP))
            condBody="wfCoreService.test(activedata."+targetField+", '"+targetDBValueOP+"', null)";
        else if ("ENTITYFIELD".equalsIgnoreCase(paramType)||"CONTEXT".equalsIgnoreCase(paramType))
        {
            if(!StringUtils.isEmpty(targetValue))
                condBody="wfCoreService.test(activedata."+targetField+", '"+targetDBValueOP+"', activedata."+targetValue.toLowerCase()+")";
            else
                condBody="wfCoreService.test(activedata."+targetField+", '"+targetDBValueOP+"', null)";
        }
        else if("CURTIME".equalsIgnoreCase(paramType))
        {
            condBody="wfCoreService.test(activedata."+targetField+", '"+targetDBValueOP+"', wfCoreService.getnow())";
        }
        else if("OPERATOR".equalsIgnoreCase(paramType))
            condBody="wfCoreService.test(activedata."+targetField+", '"+targetDBValueOP+"', curuser.userid)";
        else if("OPERATORNAME".equalsIgnoreCase(paramType))
            condBody="wfCoreService.test(activedata."+targetField+", '"+targetDBValueOP+"', curuser.personname)";
        else if("SESSION".equalsIgnoreCase(paramType)&&(!StringUtils.isEmpty(targetValue)))
            condBody="wfCoreService.test(activedata."+targetField+", '"+targetDBValueOP+"', curuser.sessionParams."+targetValue.toLowerCase()+")";
        else if (!StringUtils.isEmpty(targetValue))
            condBody="wfCoreService.test(activedata."+targetField+", '"+targetDBValueOP+"', '"+targetValue.replace("\"","").replace("‘","").replace("“","").replace("”","")+"')";
        else if (StringUtils.isEmpty(targetValue))
            condBody="wfCoreService.test(activedata."+targetField+", '"+targetDBValueOP+"', null)";

        fieldCond=fieldCond+condBody;
        fieldCond=fieldCond+")";
        return fieldCond;
    }


}
