package cn.ibizlab.codegen.model;

import cn.ibizlab.codegen.CodegenConstants;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown = true)
public class CliData extends DataObj
{

    private static CliData EMPTY = new CliData().setOptions(new ArrayList<>());


    public CliData set(String key, Object value)
    {
        this.put(key,value);
        return this;
    }

    public CliData setAll(Map map)
    {
        if(map!=null)
            this.putAll(map);
        else if(this.size()==0)
            return null;
        return this;
    }


    private List<CliOption> options=new ArrayList<>();

    public List<CliOption> getOptions()
    {
        return options;
    }


    public CliData setOptions(List<CliOption> options) {
        options.forEach(opt->addOption(opt));
        return this;
    }

    public CliData addOption(CliOption option) {
        this.options.add(option);
        if(!StringUtils.isEmpty(option.getCliSubType()))
            addSubTypeOption(option);

        return this;
    }


    public CliData addSubTypeOption(CliOption option) {
        CliData subData=null;
        Object sub=this.get(option.getCliSubType());
        if(sub==null)
        {
            subData=new CliData();
            this.set(option.getCliSubType(),subData);
        }
        else
            subData=(CliData)sub;
        subData.getOptions().add(option);
        return this;
    }

    public CliData getSubData(String subType)
    {
        if(this.containsKey(subType))
            return (CliData)this.get(subType);
        return EMPTY;
    }


}
