package cn.ibizlab.codegen;

import cn.ibizlab.codegen.cmd.*;
import io.airlift.airline.Cli;
import io.airlift.airline.ParseArgumentsUnexpectedException;
import io.airlift.airline.ParseOptionMissingException;
import io.airlift.airline.ParseOptionMissingValueException;
import cn.ibizlab.codegen.cmd.*;

import java.util.Locale;

public class IbizLabGenerator {

    public static void main(String[] args) {
        BuildInfo buildInfo = new BuildInfo();
        Cli.CliBuilder<IbizLabGeneratorCommand> builder =
                Cli.<IbizLabGeneratorCommand>builder(Constants.CLI_NAME)
                        .withDescription(
                                String.format(
                                        Locale.ROOT,
                                        "ibizLab Generator CLI %s (%s).",
                                        buildInfo.getVersion(),
                                        buildInfo.getSha()))
                        .withDefaultCommand(HelpCommand.class)
                        .withCommands(
                                Generate.class,
                                HelpCommand.class,
                                Version.class,
                                ListCommand.class,
                                CompletionCommand.class
                        );



        try {
            builder.build().parse(args).run();

            // If CLI runs without a command, consider this an error. This exists after initial parse/run
            // so we can present the configured "default command".
            // We can check against empty args because unrecognized arguments/commands result in an exception.
            // This is useful to exit with status 1, for example, so that misconfigured scripts fail fast.
            // We don't want the default command to exit internally with status 1 because when the default command is something like "list",
            // it would prevent scripting using the command directly. Example:
            //     java -jar cli.jar list --short | tr ',' '\n' | xargs -I{} echo "Doing something with {}"
            if (args.length == 0) {
                System.exit(1);
            }
        } catch (ParseArgumentsUnexpectedException e) {
            System.err.printf(Locale.ROOT, "[error] %s%n%nSee '%s help' for usage.%n", e.getMessage(), Constants.CLI_NAME);
            System.exit(1);
        } catch (ParseOptionMissingException | ParseOptionMissingValueException e) {
            System.err.printf(Locale.ROOT, "[error] %s%n", e.getMessage());
            System.exit(1);
        }
    }
}
