package cn.ibizlab.codegen.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.model.dataentity.der.IPSDERBase;

import java.util.ArrayList;
import java.util.List;

@Getter
@Setter
@NoArgsConstructor
@Accessors(chain = true)
public class RelationshipModel extends BaseModel{

    public RelationshipModel(EntityModel entityModel, IPSDERBase der)
    {
        this.opt=der;
        this.entity=entityModel;
        this.setName(der.getName());
    }

    @Override
    public RelationshipModel setCodeName(String codeName) {
        super.setCodeName(codeName);
        this.setId(String.format("%1$s-%2$s",entity.getCodeName(),codeName));
        return this;
    }

    private EntityModel entity;

    private String entityName;

    private String entityCodeName;

    private String entityLogicName;

    private String entityId;

    private String module;

    private String tableName;


    private String relationType;

    private boolean nested;

    public String getListCode()
    {
        if(this.getDer().getMinorPSDataEntity().getStorageMode()==0)
            return getCodeName().toPluralize().toLowerCase();
        return null;
    }

    private String columnName;


    public IPSDERBase getDer()
    {
        return (IPSDERBase)opt;
    }

    private List<FieldModel> fields;

    public RelationshipModel addField(FieldModel obj)
    {
        if(fields==null)
            fields=new ArrayList<>();
        fields.add(obj);
        return this;
    }


    private List<LookupModel> lookup;

    public RelationshipModel addLookup(LookupModel obj)
    {
        if(lookup==null)
            lookup=new ArrayList<>();
        lookup.add(obj);
        return this;
    }


}
