package cn.ibizlab.codegen.model;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import net.ibizsys.model.app.IPSApplication;

import java.util.*;

@Getter
@Setter
@NoArgsConstructor
@Accessors(chain = true)
public class AppModel extends BaseModel{

    public AppModel(IPSApplication application)
    {
        this.opt=application;
        this.setCodeName(application.getCodeName());
        this.setName(application.getName());
        if(getApplication().getAllPSAppDataEntities()!=null)
        {
            getApplication().getAllPSAppDataEntities().forEach(item->{
                appEntitiesMap.put(item.getCodeName(),new AppEntityModel(this,item));
            });
        }
        if(getApplication().getAllPSAppViews()!=null)
        {
            getApplication().getAllPSAppViews().forEach(item->{
                pagesMap.put(item.getCodeName(),new PageModel(this,item));
            });
        }

    }


    private SystemModel system;

    public IPSApplication getApplication()
    {
        return (IPSApplication)opt;
    }

    private Map<String,AppEntityModel> appEntitiesMap=new LinkedHashMap<>();;

    private Map<String,PageModel> pagesMap=new LinkedHashMap<>();

    private Map<String,CtrlModel> ctrlsMap=new LinkedHashMap<>();


    public Collection<AppEntityModel> getAppEntities() {
        return appEntitiesMap.values();
    }

    public Collection<PageModel> getPages() {
        return pagesMap.values();
    }

    public Collection<CtrlModel> getCtrls() {
        return ctrlsMap.values();
    }



    public PageModel getPage(String codeName)
    {
        if(pagesMap!=null)
            return pagesMap.get(codeName);
        return null;
    }

    public AppEntityModel getAppEntity(String codeName)
    {
        if(appEntitiesMap!=null)
            return appEntitiesMap.get(codeName);
        return null;
    }

}
