package cn.ibizlab.codegen.model;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import net.ibizsys.model.dataentity.service.IPSDEServiceAPI;

@Getter
@Setter
@NoArgsConstructor
@Accessors(chain = true)
public class ApiEntityModel extends BaseModel{

    public ApiEntityModel(ApiModel apiModel,IPSDEServiceAPI apiDataEntity)
    {
        this.opt=apiDataEntity;
        this.api=apiModel;
        this.setCodeName(apiDataEntity.getCodeName());
        this.setName(apiDataEntity.getName());
        this.setId(String.format("%1$s-%2$s",api.getCodeName(),apiDataEntity.getCodeName()));
    }

    public IPSDEServiceAPI getApiDataEntity()
    {
        return (IPSDEServiceAPI)opt;
    }

    private ApiModel api;


}
