package cn.ibizlab.codegen.templating.mustache;

import cn.ibizlab.codegen.CodegenConfig;
import cn.ibizlab.codegen.utils.Inflector;
import cn.ibizlab.codegen.utils.StringAdvUtils;
import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;

import java.io.IOException;
import java.io.Writer;

/**
 * Converts text in a fragment to lowercase.
 *
 * Register:
 * <pre>
 * additionalProperties.put("lowercase", new LowercaseLambda());
 * </pre>
 *
 * Use:
 * <pre>
 * {{#lowercase}}{{httpMethod}}{{/lowercase}}
 * </pre>
 */
public class PluralizeLambda implements Mustache.Lambda {
    private CodegenConfig generator = null;

    public PluralizeLambda() {

    }

    public PluralizeLambda generator(final CodegenConfig generator) {
        this.generator = generator;
        return this;
    }

    @Override
    public void execute(Template.Fragment fragment, Writer writer) throws IOException {
        String text = Inflector.getInstance().pluralize(StringAdvUtils.camelcase(fragment.execute()).toLowerCase());

        writer.write(text);

    }
}
