
package cn.ibizlab.codegen.templating.mustache;

import cn.ibizlab.codegen.utils.StringAdvUtils;
import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;

import java.io.IOException;
import java.io.Writer;


/**
 * Converts text in a fragment to snake case.
 *
 * Register:
 * <pre>
 * additionalProperties.put("snakecase", new SnakecaseLambda());
 * </pre>
 *
 * Use:
 * <pre>
 * {{#snakecase}}{{summary}}{{/snakecase}}
 * </pre>
 */
public class SpinalcaseLambda implements Mustache.Lambda {
    @Override
    public void execute(Template.Fragment fragment, Writer writer) throws IOException {
        writer.write(StringAdvUtils.dashize(fragment.execute()));
    }
}
