package cn.ibizlab.codegen.config;

import cn.ibizlab.codegen.model.PojoOption;
import cn.ibizlab.codegen.templating.TemplateFileType;
import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.reflect.ReflectionObjectHandler;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Getter
@Setter
@NoArgsConstructor
@Accessors(chain = true)
public class Context<TSpecDocument> {
    private TSpecDocument specDocument;
    private GeneratorSettings generatorSettings;
    private static class MapMethodReflectionHandler extends ReflectionObjectHandler {
        @Override
        protected boolean areMethodsAccessible(Map<?, ?> map) {
            return true;
        }
    }

    public static void main(String[] args) throws IOException {

        Path path= Paths.get("/122/33/abc.java");
        System.out.println(path.getParent().getFileName());
        System.out.println(TemplateFileType.entity.toString());
        System.out.println(TemplateFileType.entity.value());
        HashMap<String, Object> scopes = new HashMap<String, Object>();
        scopes.put("name", "Mustache");
        GeneratorSettings generatorSettings=new GeneratorSettings().setGitHost("host");
        generatorSettings.getAdditionalProperties().put("sub",new GeneratorSettings().setGitHost("son"));
        scopes.put("feature",generatorSettings );
        List<String> list=new ArrayList<>();
        list.add("a");
        list.add("b");
        scopes.put("list",list);

        Map map=new HashMap();
        map.put("01","a01");
        map.put("02","a02");
        scopes.put("map1",map);
        scopes.put("opt",new PojoOption().set("system_name","ab").set("persistent",false));
        scopes.put("type",TemplateFileType.entity);

        Writer writer = new OutputStreamWriter(System.out);
        DefaultMustacheFactory mf = new DefaultMustacheFactory();
        mf.setObjectHandler(new MapMethodReflectionHandler());
        Mustache mustache = mf.compile(new StringReader("{{type}},{{type.value}},{{name}},{{opt.system}},{{opt.physicalField}}, {{map1.entrySet}}{{#map1.entrySet}}{{key}}{{/map1.entrySet}}!"), "example");
        mustache.execute(writer, scopes);
        writer.flush();
    }

}
