package cn.ibizlab.codegen.model;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import net.ibizsys.model.service.IPSSysServiceAPI;

import java.util.*;

@Getter
@Setter
@NoArgsConstructor
@Accessors(chain = true)
public class ApiModel extends BaseModel {

    public ApiModel(IPSSysServiceAPI api) {
        this.opt = api;
        this.setCodeName(api.getCodeName());
        this.setName(api.getName());
        if (getSysServiceApi().getPSDEServiceAPIs() != null) {
            getSysServiceApi().getPSDEServiceAPIs().forEach(item -> {
                apiEntitiesMap.put(item.getCodeName(), new ApiEntityModel(this, item));
            });
        }
        if (getSysServiceApi().getPSDEServiceAPIRSs() != null) {
            getSysServiceApi().getPSDEServiceAPIRSs().forEach(item -> {
                ApiEntityRSModel apiEntityRSModel = new ApiEntityRSModel(this, item);
                apiEntityRSMap.put(item.getName(), apiEntityRSModel);
                if (!apiEntityParentRSMap.containsKey(apiEntityRSModel.getMinorEntityCodeName())) {
                    apiEntityParentRSMap.put(apiEntityRSModel.getMinorEntityCodeName(), new ArrayList<>());
                }
                apiEntityParentRSMap.get(apiEntityRSModel.getMinorEntityCodeName()).add(apiEntityRSModel);
            });
        }

    }


    private SystemModel system;

    public IPSSysServiceAPI getSysServiceApi() {
        return (IPSSysServiceAPI) opt;
    }


    private Map<String, ApiEntityModel> apiEntitiesMap = new LinkedHashMap<>();

    public Collection<ApiEntityModel> getApiEntities() {
        return apiEntitiesMap.values();
    }

    public ApiEntityModel getApiEntity(String codeName) {
        return apiEntitiesMap.get(codeName);
    }

    private Map<String, ApiEntityRSModel> apiEntityRSMap = new LinkedHashMap<>();

    public Collection<ApiEntityRSModel> getapiEntityRSes() {
        return apiEntityRSMap.values();
    }

    public ApiEntityRSModel getApiEntityRS(String name) {
        return apiEntityRSMap.get(name);
    }


    private Map<String, List<ApiEntityRSModel>> apiEntityParentRSMap = new LinkedHashMap<>();

    public List<ApiEntityRSModel> getApiEntityParentRSes(String name) {
        return apiEntityParentRSMap.get(name);
    }
}
