package cn.ibizlab.codegen.model;

public enum PropType {
    UNKNOWN(0,"UNKNOWN","string","String"),
    BIGINT(1,"BIGINT","number","Long"),
    BINARY(2,"BINARY","string","String"),
    BIT(3,"BIT","boolean","Boolean"),
    CHAR(4,"CHAR","string","String"),
    DATETIME(5,"DATETIME","string", "Timestamp"),
    DECIMAL(6,"DECIMAL","number", "BigDecimal"),
    FLOAT(7,"FLOAT","number", "BigDecimal"),
    IMAGE(8,"IMAGE","string","String"),
    INT(9,"INT","number","Integer"),
    MONEY(10,"MONEY","number", "BigDecimal"),
    NCHAR(11,"NCHAR","string","String"),
    NTEXT(12,"NTEXT","string","String"),
    NVARCHAR(13,"NVARCHAR","string","String"),
    NUMERIC(14,"NUMERIC","number", "BigDecimal"),
    REAL(15,"REAL","number","Float"),
    SMALLDATETIME(16,"SMALLDATETIME","string", "Timestamp"),
    SMALLINT(17,"SMALLINT","number","Integer"),
    SMALLMONEY(18,"SMALLMONEY","number", "BigDecimal"),
    SQL_VARIANT(19,"SQL_VARIANT","string","String"),
    SYSNAME(20,"SYSNAME","string","String"),
    TEXT(21,"TEXT","string","String"),
    TIMESTAMP(22,"TIMESTAMP","string","Timestamp"),
    TINYINT(23,"TINYINT","number","Integer"),
    VARBINARY(24,"VARBINARY","string","String"),
    VARCHAR(25,"VARCHAR","string","String"),
    UNIQUEIDENTIFIER(26,"UNIQUEIDENTIFIER","string","String"),
    DATE(27,"DATE","string", "Timestamp"),
    TIME(28,"TIME","string", "Timestamp"),
    BIGDECIMAL(29,"BIGDECIMAL","number", "BigDecimal");

    public final int code;
    public final String name;
    public final String json;
    public final String java;

    private PropType(int code, String name, String json, String java) {
        this.code = code;
        this.name = name;
        this.json = json;
        this.java = java;
    }

    public int getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public String getJson() {
        return json;
    }

    public String getJava() {
        return java;
    }

    public boolean isString()
    {
        return "String".equalsIgnoreCase(java);
    }

    public boolean isNumber()
    {
        return "BigDecimal".equalsIgnoreCase(java)||"Long".equalsIgnoreCase(java)||"Integer".equalsIgnoreCase(java);
    }

    public static PropType findType(Integer type) {
        for (PropType userTypeEnum : values()) {
            if (userTypeEnum.getCode()==type) {
                return userTypeEnum;
            }
        }
        return PropType.VARCHAR;
    }

    public static PropType findByDBType(String type) {
        for (PropType userTypeEnum : values()) {
            if (userTypeEnum.getName()==type) {
                return userTypeEnum;
            }
        }
        return VARCHAR;
    }

}
