package cn.ibizlab.codegen.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Getter
@Setter
@NoArgsConstructor
@Accessors(chain = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class EmbedTemplate {
    private String name;
    private String version;

    @JsonCreator
    public static EmbedTemplate from(String tag) {
        if(ObjectUtils.isEmpty(tag))
            return null;
        tag=DynamicParamUtils.process(tag);
        EmbedTemplate template=new EmbedTemplate();
        String tags[]=tag.split(":");
        if(tags.length==0)
            return null;
        template.setName(tags[0].trim());
        if(tags.length>1)
            template.setVersion(tags[1].trim());
        else
            template.setVersion("1.0-SNAPSHOT");
        if(StringUtils.isEmpty(template.getName()))
            return null;
        return template;
    }

}
