package cn.ibizlab.codegen.model;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import net.ibizsys.model.service.IPSSubSysServiceAPI;
import net.ibizsys.model.system.IPSSystemModule;

import java.util.*;

@Getter
@Setter
@NoArgsConstructor
@Accessors(chain = true)
public class SubServiceApiModel extends BaseModel {

    private SystemModel system;

    private Map<String, SubEntityApiModel> subEntityApi = new LinkedHashMap<>();

    public SubServiceApiModel(IPSSubSysServiceAPI iPSSubSysServiceAPI) {
        this.opt = iPSSubSysServiceAPI;
        this.setCodeName(iPSSubSysServiceAPI.getCodeName());
        this.setName(iPSSubSysServiceAPI.getName());
    }

    public Collection<SubEntityApiModel> getSubEntityApis() {
        return subEntityApi.values();
    }

    public SubEntityApiModel getSubEntityApi(String codeName) {
        return subEntityApi.get(codeName);
    }

    public IPSSubSysServiceAPI getPSSubSysServiceAPI() {
        return (IPSSubSysServiceAPI)opt;
    }

    public String module;

    public String getModule()
    {
        if(module==null)
        {
            IPSSystemModule systemModule = getPSSubSysServiceAPI().getPSSystemModule();
            if(systemModule!=null&&systemModule.getCodeName()!=null&&systemModule.getPSSysModelGroup() == null) {
                module = getPSSubSysServiceAPI().getPSSystemModule().getCodeName().toLowerCase();
                if("rt".equals(module))
                    module="";
            }
            else
                module="";
        }
        return module;
    }

}
