package cn.ibizlab.codegen.templating;

import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

/**
 * Locates generator-agnostic templates from a common built-in location.
 */
public class CommonTemplateContentLocator implements TemplatePathLocator {
    private String resourceLocation = "_common";

    /**
     * Constructs a new instance of {@link CommonTemplateContentLocator} defaulting to _common resource location.
     */
    public CommonTemplateContentLocator() {

    }

    /**
     * Constructs a new instance of {@link CommonTemplateContentLocator} for a targeted common location.
     *
     * @param resourceLocation A custom common file location.
     */
    public CommonTemplateContentLocator(String resourceLocation) {
        this.resourceLocation = resourceLocation;
    }

    public String getResourceLocation() {
        return resourceLocation;
    }

    /**
     * Get the full path to a relative template file.
     *
     * @param relativeTemplateFile Template file
     * @return String Full template file path
     */
    @Override
    public String getFullTemplatePath(String relativeTemplateFile) {
        if (StringUtils.isNotEmpty(relativeTemplateFile)) {
            String loc = Paths.get(this.resourceLocation , relativeTemplateFile).toString();

            URL url = this.getClass().getClassLoader().getResource(TemplateManager.getCPResourcePath(loc));
            if (url != null) {
                return loc;
            }
        }
        return null;
    }

    public List<String> getTemplatePaths() {
        List<String> list = getList(this.resourceLocation+"/**");

        return list;
    }


    public List<String> getList(String rootDir)  {
        List<String> list=new ArrayList<>();
        try
        {
            ResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver();
            Resource[] resource=resourceResolver.getResources("classpath:"+rootDir);
            for(Resource file:resource)
            {
                if(file instanceof ClassPathResource)
                {
                    String path=((ClassPathResource)file).getPath();
                    String name=file.getFilename();
                    path=path.replaceAll("\\\\","/");
                    if(path.endsWith("/"))
                        continue;
                    path=path.substring(rootDir.length()-2);
                    list.add(path);
                }
                else if(file instanceof FileSystemResource)
                {
                    String path=((FileSystemResource)file).getPath();
                    String name=file.getFilename();
                    if(file.getFile().isDirectory())
                        continue;
                    path=path.replaceAll("\\\\","/");
                    String atStr="/modules/ibizlab-generator-core/target/classes/";
                    int at="/modules/ibizlab-generator-core/target/classes/".length()+rootDir.length()-2;
                    path=path.substring(path.indexOf(atStr)+at);
                    list.add(path);
                }

            }



        }catch (Exception ex){
            ex.printStackTrace();
        }

        return list;
    }

}
