package cn.ibizlab.codegen.model;


import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import net.ibizsys.model.codelist.IPSCodeItem;
import org.springframework.util.ObjectUtils;

import java.util.*;

@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class Option
{
	private String id;
	private Object value;
	private String label;
	private List<Option> children;
	private String iconClass;
	private String filter;
	private Boolean disabled;
	private String parent;
	private Map<String, Object> extension;

	@JsonIgnore
	@JSONField(serialize = false)
	public Set<String> getFilterSet()
	{
		Set<String> set=new HashSet<>();
		if(!ObjectUtils.isEmpty(filter))
			for(String str:filter.split(";|,"))
				set.add(str);
		return set;
	}

	@JsonIgnore
	@JSONField(serialize = false)
	public String getValueType()
	{
		if(value==null || value instanceof CharSequence)
			return "String";
		else
			return "Integer";
	}

	@JsonIgnore
	@JSONField(serialize = false)
	public String getName()
	{
		String name = "V_" +  getValue().toString().replace("(","").replace(")","")
				.replace("（","").replace("）","")
				.replace(":","").replace("：","")
				.replace("、","").replace(".","")
				.replace("。","").replace(";","")
				.replace("；","").replace("-","")
				.replace(",","").replace("\\","")
				.replace("/","").replace("，","").replace("%","");

		return name;
	}

	public Option addChildren(Option item) {
		if(children==null)
			children=new ArrayList<Option>();
		children.add(item);
		item.setParent(this.getValue().toString());
		return this;
	}

	public Option setItem(IPSCodeItem item)
	{
		this.setId(item.getValue()).setValue(item.getValue()).setLabel(item.getText()).setIconClass(item.getIconCls());
		if(!ObjectUtils.isEmpty(item.getPSCodeItems()))
		{
			item.getPSCodeItems().forEach(child->{
				this.addChildren(new Option().setItem(child));
			});
		}
		return this;
	}


}
