package cn.ibizlab.codegen.model;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import net.ibizsys.model.dataentity.action.IPSDEAction;
import net.ibizsys.model.dataentity.action.IPSDELogicAction;
import net.ibizsys.model.dataentity.action.IPSDEScriptAction;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.util.HashSet;
import java.util.Set;

@Getter
@Setter
@NoArgsConstructor
@Accessors(chain = true)
public class ActionModel extends BaseModel{

    public ActionModel(EntityModel entityModel, IPSDEAction action)
    {
        this.opt=action;
        this.entity=entityModel;
        this.setCodeName(action.getCodeName());
        this.setName(action.getName());
        this.setId(String.format("%1$s-%2$s",entity.getCodeName(),action.getCodeName()));
    }

    public IPSDEAction getDEAction()
    {
        return (IPSDEAction)opt;
    }

    private EntityModel entity;

    public boolean isGetAction()
    {
        return codeName.toLowerCase().startsWith("get");
    }

    public String getInParam()
    {
        String param=this.getEntity().getCodeName();
        if(getDEAction().getPSDEActionInput()==null)
            return param;
        if("KEYFIELD".equalsIgnoreCase(getDEAction().getPSDEActionInput().getType()))
            param=this.getEntity().getKeyField().getType().java;
        else if("KEYFIELDS".equalsIgnoreCase(getDEAction().getPSDEActionInput().getType()))
            param="List<"+this.getEntity().getKeyField().getType().java+">";
        else if("DTOS".equalsIgnoreCase(getDEAction().getPSDEActionInput().getType()))
            param="List<"+param+">";
        return param;
    }

    public String getInParamName()
    {
        String param="dto";
        if(getDEAction().getPSDEActionInput()==null)
            return param;
        if("KEYFIELD".equalsIgnoreCase(getDEAction().getPSDEActionInput().getType()))
            param="key";
        else if("KEYFIELDS".equalsIgnoreCase(getDEAction().getPSDEActionInput().getType()))
            param="keys";
        return param;
    }

    public boolean isVoidReturn()
    {
        if(getDEAction().getPSDEActionReturn()==null)
            return true;
        if (!"VOID".equalsIgnoreCase(getDEAction().getPSDEActionReturn().getType()))
            return false;
        return true;
    }

    public boolean isListReturn()
    {
        if(getDEAction().getPSDEActionReturn()==null)
            return false;
        if ("DTOS".equalsIgnoreCase(getDEAction().getPSDEActionReturn().getType())
                ||"OBJECTS".equalsIgnoreCase(getDEAction().getPSDEActionReturn().getType())
                ||"SIMPLES".equalsIgnoreCase(getDEAction().getPSDEActionReturn().getType()))
            return true;
        return false;
    }

    public String typeReturn()
    {
        if(isListReturn()) {
            if ("SIMPLES".equalsIgnoreCase(getDEAction().getPSDEActionReturn().getType()))
                return PropType.findType(this.getDEAction().getPSDEActionReturn().getStdDataType()).java;
            else if ("DTOS".equalsIgnoreCase(getDEAction().getPSDEActionReturn().getType())
                    ||"OBJECTS".equalsIgnoreCase(getDEAction().getPSDEActionReturn().getType()))
                return this.getEntity().getCodeName();
        }
        return "";
    }

    public String getOutParam()
    {
        String param=this.getEntity().getCodeName();
        if(getDEAction().getPSDEActionReturn()==null)
            return param;
        if ("VOID".equalsIgnoreCase(getDEAction().getPSDEActionReturn().getType()))
            return getInParam();
        if ("SIMPLE".equalsIgnoreCase(getDEAction().getPSDEActionReturn().getType()))
            param=PropType.findType(this.getDEAction().getPSDEActionReturn().getStdDataType()).java;
        else if ("SIMPLES".equalsIgnoreCase(getDEAction().getPSDEActionReturn().getType()))
            param="List<"+PropType.findType(this.getDEAction().getPSDEActionReturn().getStdDataType()).java+">";
        else if ("DTOS".equalsIgnoreCase(getDEAction().getPSDEActionReturn().getType())
                ||"OBJECTS".equalsIgnoreCase(getDEAction().getPSDEActionReturn().getType()))
            param="List<"+param+">";
        return param;
    }

    public Set<String> getLogics()
    {
        Set<String> validLogic=new HashSet<>();
        if(!ObjectUtils.isEmpty(getDEAction().getBeforePSDEActionLogics()))
        {
            getDEAction().getBeforePSDEActionLogics().forEach(logic->{
                if ((logic.isValid()  && logic.isInternalLogic() && logic.getPSDELogic().isEnableBackend()) ||
                (logic.getDstPSDE()!=null && logic.getDstPSDEAction()!=null && (!(logic.getDstPSDEAction() instanceof IPSDEScriptAction))))
                    validLogic.add((entity.codeName+this.codeName).toLowerCase()+"before.bpmn");
            });
        }
        if(!ObjectUtils.isEmpty(getDEAction().getAfterPSDEActionLogics()))
        {
            getDEAction().getAfterPSDEActionLogics().forEach(logic->{
                if ((logic.isValid()  && logic.isInternalLogic() && logic.getPSDELogic().isEnableBackend()) ||
                        (logic.getDstPSDE()!=null && logic.getDstPSDEAction()!=null && (!(logic.getDstPSDEAction() instanceof IPSDEScriptAction))))
                    validLogic.add((entity.codeName+this.codeName).toLowerCase()+"after.bpmn");
            });
        }
        if("DELOGIC".equalsIgnoreCase(getDEAction().getActionType())&&getDEAction() instanceof IPSDELogicAction)
        {
            validLogic.add((entity.codeName+this.codeName).toLowerCase()+"exec.bpmn");
        }
        return validLogic;
    }

}
