package cn.ibizlab.codegen.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.nio.file.Path;
import java.nio.file.Paths;

@Getter
@Setter
@NoArgsConstructor
@Accessors(chain = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Volume {

    private String source;
    private String target;

    public void setSource(String source) {
        this.source = source.replace("\\", "/");
    }

    public void setTarget(String target) {
        this.target = target.replace("\\", "/");
    }

    public Path getSourcePath() {
        return Paths.get(source);
    }

    @JsonCreator
    public static Volume from(String tag) {
        if(ObjectUtils.isEmpty(tag))
            return null;
        tag=DynamicParamUtils.process(tag);
        Volume volume=new Volume();
        String tags[]=tag.split(":");
        if(tags.length==0)
            return null;
        volume.setSource(tags[0].trim());
        if(tags.length>1)
            volume.setTarget(tags[1].trim());
        else
            volume.setTarget(tags[0].trim());
        if(StringUtils.isEmpty(volume.getSource()))
            return null;
        return volume;
    }


}
