package cn.ibizlab.codegen.config;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.*;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.Serializable;
import java.util.*;

@Getter
@Setter
@NoArgsConstructor
@Accessors(chain = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class GeneratorSettings implements Serializable {

    private static final Logger LOGGER = LoggerFactory.getLogger(GeneratorSettings.class);



    private String projectName;
    private String packageName;

    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<>();


    private String output ;

    private String inputSpec;


    private List<String> inputSpecFilters;

    private List<String> templateDirs;

    private List<String> templatePaths;

    private List<String> templateFilters;

    private List<Volume> volumes;

    private String auth;

    private List<EmbedTemplate> embedTemplates;

    @JsonAnyGetter
    public Map<String , Object> any() {
        return additionalProperties;
    }

    @JsonAnySetter
    public void set(String field, Object value) {
        this.additionalProperties.put(field ,DynamicParamUtils.processObject(value));
    }


    public void setProjectName(String projectName) {
        this.projectName = DynamicParamUtils.process(projectName);
    }

    public void setPackageName(String packageName) {
        this.packageName = DynamicParamUtils.process(packageName);
    }


    public void setOutput(String output) {
        this.output = DynamicParamUtils.process(output);
    }

    public void setInputSpec(String inputSpec) {
        this.inputSpec = DynamicParamUtils.process(inputSpec);
    }

    public void setInputSpecFilters(List<String> inputSpecFilters) {
        this.inputSpecFilters = DynamicParamUtils.process(inputSpecFilters);
    }

    public void setTemplateDirs(List<String> templateDirs) {
        this.templateDirs = DynamicParamUtils.process(templateDirs);
    }

    public void setTemplatePaths(List<String> templatePaths) {
        this.templatePaths = DynamicParamUtils.process(templatePaths);
    }

    public void setTemplateFilters(List<String> templateFilters) {
        this.templateFilters = DynamicParamUtils.process(templateFilters);
    }


    public void setAuth(String auth) {
        this.auth = DynamicParamUtils.process(auth);
    }

}
