package cn.ibizlab.codegen.config;

import cn.ibizlab.codegen.model.PojoOption;
import cn.ibizlab.codegen.templating.TemplateFileType;
import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.reflect.ReflectionObjectHandler;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Getter
@Setter
@NoArgsConstructor
@Accessors(chain = true)
public class Context<TSpecDocument> {
    private TSpecDocument specDocument;
    private GeneratorSettings generatorSettings;
    private static class MapMethodReflectionHandler extends ReflectionObjectHandler {
        @Override
        protected boolean areMethodsAccessible(Map<?, ?> map) {
            return true;
        }
    }

}
