package cn.ibizlab.codegen.templating;

import cn.ibizlab.codegen.CodegenConfig;

import java.io.File;

/**
 * Locates templates according to {@link CodegenConfig} settings.
 */
public class GeneratorTemplateContentLocator implements TemplatePathLocator {
    private String templateDir;

    public GeneratorTemplateContentLocator(String templateDir) {
        this.templateDir = templateDir;
    }


    @Override
    public String getFullTemplatePath(String relativeTemplateFile) {


        // check the supplied template main folder for the file
        // File.separator is necessary here as the file load is OS-specific
        final String template = templateDir + File.separator + relativeTemplateFile;
        // looks for user-defined file or classpath
        // supports template dir which refers to local file system or custom path in classpath as defined by templateDir
        if (new File(template).exists()) {
            return template;
        }



        return null;
    }
}
