package cn.ibizlab.codegen.model;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import net.ibizsys.model.service.IPSSubSysServiceAPI;

import java.util.*;

@Getter
@Setter
@NoArgsConstructor
@Accessors(chain = true)
public class SubServiceApiModel extends BaseModel {

    private SystemModel system;

    private Map<String, SubEntityApiModel> subEntityApi = new LinkedHashMap<>();

    public SubServiceApiModel(IPSSubSysServiceAPI iPSSubSysServiceAPI) {
        this.opt = iPSSubSysServiceAPI;
        this.setCodeName(iPSSubSysServiceAPI.getCodeName());
        this.setName(iPSSubSysServiceAPI.getName());
    }

    public Collection<SubEntityApiModel> getSubEntityApis() {
        return subEntityApi.values();
    }

    public SubEntityApiModel getSubEntityApi(String codeName) {
        return subEntityApi.get(codeName);
    }

}
