package cn.ibizlab.codegen.model;

import cn.ibizlab.codegen.utils.StringAdvUtils;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.model.dataentity.der.IPSDERBase;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Getter
@Setter
@NoArgsConstructor
@Accessors(chain = true)
public class RelationshipModel extends BaseModel{

    public RelationshipModel(EntityModel entityModel, IPSDERBase der)
    {
        this.opt=der;
        this.ownerEntity=entityModel;
        this.setName(der.getName());
    }

    @Override
    public RelationshipModel setCodeName(String codeName) {
        super.setCodeName(codeName);
        this.setId(String.format("%1$s-%2$s",ownerEntity.getCodeName(),codeName));
        return this;
    }

    private EntityModel ownerEntity;

    private EntityModel relEntity;

    public EntityModel getRelEntity()
    {
        if(relEntity==null&&ownerEntity!=null&&(!StringUtils.isEmpty(entityCodeName)))
        {
            relEntity=ownerEntity.getSystem().getEntity(entityCodeName);
        }
        return relEntity;
    }

    private String entityName;

    private String entityCodeName;

    private String entityLogicName;

    private String entityId;

    private String module;

    private String tableName;


    private String relationType;


    public String getListCode()
    {
        if(this.getDer().getMinorPSDataEntity().getStorageMode()==0)
            return StringAdvUtils.pluralize(getCodeName());
        return null;
    }

    private String columnName;


    public IPSDERBase getDer()
    {
        return (IPSDERBase)opt;
    }

    private List<FieldModel> fields;

    public RelationshipModel addField(FieldModel obj)
    {
        if(fields==null)
            fields=new ArrayList<>();
        fields.add(obj);
        return this;
    }

    private FieldModel fkField;

    private String fkFieldCodeName;

    public FieldModel getFkField()
    {
        if(fkField==null&&(!StringUtils.isEmpty(fkFieldCodeName)))
        {
            if("nested".equalsIgnoreCase(this.relationType)&&relEntity!=null)
            {
                fkField=relEntity.getFieldMap().get(fkFieldCodeName);
            }
            else if(ownerEntity!=null)
            {
                fkField=ownerEntity.getFieldMap().get(fkFieldCodeName);
            }
        }
        return fkField;
    }

    public int getRelFieldCount()
    {
        return ObjectUtils.isEmpty(fields)?1:fields.size();
    }

    private Map<String,LookupModel> lookup;

    public RelationshipModel addLookup(LookupModel obj)
    {
        if(lookup==null)
            lookup=new LinkedHashMap<>();
        lookup.put(obj.getFieldname()+obj.getReffieldname(),obj);
        return this;
    }


}
