package cn.ibizlab.codegen.model;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.model.dataentity.service.IPSDEMethodDTO;
import net.ibizsys.model.dataentity.service.IPSDEMethodDTOField;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;

@Getter
@Setter
@NoArgsConstructor
@Accessors(chain = true)
public class ApiDtoFieldModel extends BaseModel {

    private ApiDtoModel apiDto;

    private String type = "";

    public ApiDtoFieldModel(ApiDtoModel apiDto, IPSDEMethodDTOField iPSDEMethodDTOField) {
        this.opt = iPSDEMethodDTOField;
        this.apiDto = apiDto;
        this.type = iPSDEMethodDTOField.getType();
        this.setCodeName(iPSDEMethodDTOField.getName());
        this.setName(iPSDEMethodDTOField.getPSDEField()==null?iPSDEMethodDTOField.getName():iPSDEMethodDTOField.getPSDEField().getName());
    }

    public IPSDEMethodDTOField getPSDEMethodDTOField() {
        return (IPSDEMethodDTOField) opt;
    }

    public String getJavaType() {
        if (type.equals("DTO")) {
            return getPSDEMethodDTOField().getRefPSDEMethodDTO().getName();
        } else if (type.equals("DTOS")) {
            return String.format("List<%s>", getPSDEMethodDTOField().getRefPSDEMethodDTO().getName());
        } else if (type.equals("SIMPLE")) {
            return PropType.findType(getPSDEMethodDTOField().getStdDataType()).java;
        } else if (type.equals("SIMPLES")) {
            return String.format("List<%s>", PropType.findType(getPSDEMethodDTOField().getStdDataType()).java);
        }
        return "String";
    }

    public String getLogicName() {
        if (StringUtils.isBlank(getPSDEMethodDTOField().getLogicName())) {
            if (getPSDEMethodDTOField().getRefPSDataEntity() != null)
                return getPSDEMethodDTOField().getRefPSDataEntity().getLogicName();
        }
        return getPSDEMethodDTOField().getLogicName();
    }


    private String format;
    private String timeType;

    public String getTimeType()
    {
        getFormat();
        return timeType;
    }

    public String getFormat(){
        if("Timestamp".equals(getJavaType())&& org.springframework.util.StringUtils.isEmpty(format)&&getPSDEMethodDTOField().getPSDEField()!=null)
        {
            if(getPSDEMethodDTOField().getPSDEField().getDataType().equals("DATE")||"%1$tY-%1$tm-%1$td".equalsIgnoreCase(getPSDEMethodDTOField().getPSDEField().getValueFormat())){
                timeType="DATE";
                format = "yyyy-MM-dd";
            }
            else if(getPSDEMethodDTOField().getPSDEField().getDataType().equals("TIME")||"%1$tH:%1$tM:%1$tS".equalsIgnoreCase(getPSDEMethodDTOField().getPSDEField().getValueFormat())){
                timeType="TIME";
                format = "HH:mm:ss";
            }
            else{
                timeType="DATETIME";
                format = "yyyy-MM-dd HH:mm:ss";
            }
        }
        return format;
    }

    public String getJsonName() {
        return getPSDEMethodDTOField().getName().toLowerCase();
    }

    public boolean isPredefinedType(){
        if(getPSDEMethodDTOField().getPSDEField()!=null){
            return StringUtils.isNotEmpty(getPSDEMethodDTOField().getPSDEField().getPredefinedType());
        }
        return false;
    }

    public boolean isKeyDEField(){
        if(getPSDEMethodDTOField().getPSDEField()!=null){
            return getPSDEMethodDTOField().getPSDEField().isKeyDEField();
        }
        return false;
    }

}
