package cn.ibizlab.codegen.model;

import cn.ibizlab.codegen.utils.DataObject;
import cn.ibizlab.codegen.utils.Inflector;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import net.ibizsys.model.database.IPSDEFDTColumn;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.model.dataentity.defield.IPSLinkDEField;
import net.ibizsys.model.dataentity.der.IPSDER1N;
import net.ibizsys.model.dataentity.der.IPSDERBase;
import net.ibizsys.model.dataentity.ds.IPSDEDataSetGroupParam;
import net.ibizsys.model.dataentity.ds.PSDEDataSetGroupParamImpl;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.util.*;

@Getter
@Setter
@NoArgsConstructor
@Accessors(chain = true)
public class EntityModel  extends BaseModel {

    
    private SystemModel system;
    
    
    public String getEntityName() {
        return getDataEntity().getName();
    }

    
    
    public String getTableName() {
        return getDataEntity().getTableName();
    }

    
    
    public String getLogicName() {
        return getDataEntity().getLogicName();
    }

    public String getModule() {
        if(getDataEntity().getPSSystemModule()!=null)
            return getDataEntity().getPSSystemModule().getCodeName().toLowerCase();
        return "ungroup";
    }


    public IPSDataEntity getDataEntity(){
        return (IPSDataEntity)opt;
    }

    private List<DataSetModel> dataSets;

    public EntityModel addDataSet(DataSetModel dataSet)
    {
        if(dataSets==null)
            dataSets=new ArrayList<>();
        dataSets.add(dataSet);
        return this;
    }

    private List<FieldModel> fields;

    public EntityModel addField(FieldModel fieldModel)
    {
        if(fields==null)
            fields=new ArrayList<>();
        fields.add(fieldModel);
        return this;
    }

    private List<RelationshipModel> references;

    public EntityModel addReference(RelationshipModel relationshipModel)
    {
        if(references==null)
            references=new ArrayList<>();
        references.add(relationshipModel);
        return this;
    }

    
    
    private Map<String,RelationshipModel> refMaps;
    
    
    public Map<String,RelationshipModel> getRefMaps()
    {
        if(refMaps==null)
            refMaps=new LinkedHashMap<>();
        if(references!=null)
        {
            references.forEach(ship->{
                if(!StringUtils.isEmpty(ship.getCodeName()))
                    refMaps.put(ship.getCodeName().toString(),ship);
                String fkname= DataObject.getStringValue(ship.getName(),"");
                if(!StringUtils.isEmpty(fkname))
                    refMaps.put(fkname, ship);
            });
        }
        return refMaps;
    }

    private List<RelationshipModel> nesteds;

    public EntityModel addNested(RelationshipModel relationshipModel)
    {
        if(nesteds==null)
            nesteds=new ArrayList<>();
        nesteds.add(relationshipModel);
        return this;
    }

    
    
    private Map<String, FieldModel> fieldMap = null;

    
    
    public Map<String, FieldModel> getFieldMap()
    {
        if(fields!=null&&fieldMap==null)
        {
            fieldMap=new LinkedHashMap<>();
            fields.forEach(field->{
                fieldMap.put(field.getFieldName(),field);
                fieldMap.put(field.getCodeName().toString(),field);
            });
        }
        return fieldMap;
    }

    
    
    private FieldModel lastModifyField;
    
    
    public FieldModel getLastModifyField() {
        if(fields!=null&&lastModifyField==null)
            for(FieldModel fieldModel:fields)
                if(fieldModel.isLastModifyField())
				{
					lastModifyField=fieldModel;
					return lastModifyField;
				}
        return lastModifyField;
    }


    
    public boolean isLogicValid()
    {
        return getDataEntity().isLogicValid();
    }
	
	
    private FieldModel logicValidField;
	
	
	public FieldModel getLogicValidField() {
		if(isLogicValid()&&logicValidField==null) {
			if (fields != null) {
				for (FieldModel fieldModel : fields) {
					if (fieldModel.isLogicValidField()) {
						logicValidField = fieldModel;
						return logicValidField;
					}
				}
			}
		}
		return logicValidField;
	}


	
	public String getValidLogicValue()
	{
		String validLogicValue=this.getDataEntity().getValidLogicValue();
		if(StringUtils.isEmpty(validLogicValue))
            validLogicValue="1";
		return validLogicValue;
	}
	

	public String getInvalidLogicValue()
	{
        String invalidLogicValue=this.getDataEntity().getInvalidLogicValue();
		if(StringUtils.isEmpty(invalidLogicValue))
            invalidLogicValue="0";
		return invalidLogicValue;
	}
	
	
	private FieldModel keyField;
    
    
    public FieldModel getKeyField() {
        if(fields!=null&&keyField==null)
            for(FieldModel fieldModel:fields)
                if(fieldModel.isKeyDEField()) {
					keyField=fieldModel;
					return keyField;
				}
        return keyField;
    }

	
	
    private List<FieldModel> unionKeyFields;
	
	
	public List<FieldModel> getUnionKeyFields() {
		if(fields!=null&&unionKeyFields==null) {
			unionKeyFields = new ArrayList<>();
			for (FieldModel fieldModel : fields)
				if (fieldModel.isUnionKeyField())
					unionKeyFields.add(fieldModel);
		}
		return unionKeyFields;
	}

    public boolean isUnionKeyMode(){
	    return !ObjectUtils.isEmpty(getUnionKeyFields());
    }
    
    public List<FieldModel> getKeyFields() {
        if(this.getKeyField()!=null&&this.getKeyField().isPhisicalDEField()) {
            List<FieldModel> keyFields = new ArrayList<>();
            keyFields.add(getKeyField());
            return keyFields;
        }
        else
            return getUnionKeyFields();
    }


    private List<DEActionModel> actions;

    public EntityModel addAction(DEActionModel action)
    {
        if(actions==null)
            actions=new ArrayList<>();
        actions.add(action);
        return this;
    }
    
    public String getDsName()
    {
        String dsName=this.getDataEntity().getDSLink();
        if(StringUtils.isEmpty(dsName)||"DEFAULT".equalsIgnoreCase(dsName))
        {
            dsName="master";
        }
        return dsName;
    }

    public String getDataSource()
    {
        String dsName=this.getDataEntity().getDSLink();
        if(StringUtils.isEmpty(dsName)||"DEFAULT".equalsIgnoreCase(dsName))
            dsName=null;
        else
            dsName=dsName.toLowerCase();
        return dsName;
    }



    public String getTableName(String dsType)
    {
        return this.getStringValue("table-"+dsType.toLowerCase(),getTableName());
    }

    



	private String storageMode="SQL";

	public void setStorageMode(Integer type)
    {
        switch(type){
            case 0:
                this.storageMode="NONE";
                break;
            case 1:
                this.storageMode="SQL";
                break;
            case 2:
                this.storageMode="NoSQL";
                break;
            case 4:
                this.storageMode="ServiceAPI";
                break;
            default:
                this.storageMode="SQL";
                break;
        }
    }
    public void setStorageMode(String type)
    {
        this.storageMode=type;
    }



    private Map<String, POSchema> poSchemas;

    public POSchema getDefaultPOSchema()
    {
        return getPOSchema("default");
    }
    public EntityModel addPOSchema(String name, POSchema poSchema)
    {
        if(poSchema!=null)
        {
            if(poSchemas==null)
                poSchemas=new LinkedHashMap<>();
            poSchemas.put(name,poSchema.build());
        }

        return this;
    }
    public POSchema getPOSchema(String name)
    {

        if(StringUtils.isEmpty(name)&&(!StringUtils.isEmpty(this.getDsName())))
            name=this.getDsName();
        if(StringUtils.isEmpty(name))
            name="mysql";

        if(poSchemas==null)
            poSchemas=new LinkedHashMap<>();
        if(poSchemas.containsKey(name))
        {
            return poSchemas.get(name);
        }
        String vendorProvider=POSchema.provider.get(name.toLowerCase());
        if((!StringUtils.isEmpty(vendorProvider))&&(!name.equalsIgnoreCase(vendorProvider))&&poSchemas.containsKey(vendorProvider))
            return poSchemas.get(vendorProvider);

        if(poSchemas.size()>0)
            return poSchemas.values().iterator().next();

        return null;
    }



    public String getStringValue(String key,String defaultVal)
    {
        return extParams.getStringValue(key,defaultVal);
    }

    private boolean hasResetField=false;


    public EntityModel(SystemModel systemModel,IPSDataEntity dataEntity)
    {
        Assert.notNull(dataEntity,"未找到对应的实体模型:"+dataEntity.getId());
        this.opt=dataEntity;
        this.system=systemModel;
        this.setCodeName(dataEntity.getCodeName());
        this.setName(dataEntity.getName());
        this.setStorageMode(dataEntity.getStorageMode());
        List<String> dsTypes=new ArrayList<>();

        if(dataEntity.getAllPSDEDBConfigs()!=null)
        {
            dataEntity.getAllPSDEDBConfigs().forEach(item->{
                String dbType=item.getDBType().toLowerCase().replace("mysql5","mysql");
                if("mysql".equals(dbType))
                    system.setEnableMysql(true);
                else if("oracle".equals(dbType))
                    system.setEnableOracle(true);
                else if("postgresql".equals(dbType))
                    system.setEnablePostgreSQL(true);
                else if("dameng".equals(dbType)||"dm".equals(dbType))
                    system.setEnableDameng(true);
                dsTypes.add(dbType);
                if(!this.getTableName().equalsIgnoreCase(item.getTableName()))
                    this.set("table-"+item.getDBType().toLowerCase().replace("mysql5","mysql"),item.getTableName());
            });
        }




        if(dataEntity.getMinorPSDERs()!=null)
        {
            for(IPSDERBase der : dataEntity.getMinorPSDERs())
            {
                RelationshipModel rel=new RelationshipModel(this,der);
                rel.setRelationType(der.getDERType()).setCodeName(der.getCodeName()).setEntityId(der.getMajorPSDataEntity().getId())
                        .setEntityCodeName(der.getMajorPSDataEntity().getCodeName()).setEntityName(der.getMajorPSDataEntity().getName())
                        .setEntityLogicName(der.getMajorPSDataEntity().getLogicName()).setTableName(der.getMajorPSDataEntity().getTableName());
                if(der.getMajorPSDataEntity().getPSSystemModule()!=null)
                    rel.setModule(der.getMajorPSDataEntity().getPSSystemModule().getCodeName().toLowerCase());



                if(der instanceof IPSDER1N)
                {
                    IPSDER1N der1n=(IPSDER1N)der;
                    String relfieldname=der1n.getPSPickupDEField().getObjectNode().get("getRelatedPSDEField").get("name").asText();

                    LookupModel lookupModel=new LookupModel().setRelationid(der.getId())
                            .setFieldname(der1n.getPickupDEFName()).setReffieldname(relfieldname);
                    rel.addLookup(lookupModel);
                }


                this.addReference(rel);
            }

        }

        if(dataEntity.getMajorPSDERs()!=null)
        {
            for(IPSDERBase der : dataEntity.getMajorPSDERs())
            {
                if(der instanceof IPSDER1N)
                {
                    IPSDER1N der1n=(IPSDER1N)der;
                    String codeName=der.getMinorCodeName();
                    boolean nestedRS=false;
                    if(der1n.isNestedRS())
                        nestedRS=true;
                    else if(der1n.getPSOne2ManyDataDEField()!=null)
                    {
                        nestedRS=true;
                    }
                    else if(der1n.getMinorPSDataEntity().getPSSubSysServiceAPIDE()!=null&&der1n.getMinorPSDataEntity().getPSSubSysServiceAPIDE().isNested())
                    {
                        nestedRS=true;
                    }
                    if(!nestedRS)
                        continue;

                    if(StringUtils.isEmpty(codeName))
                        codeName=der.getMinorPSDataEntity().getCodeName();

                    RelationshipModel rel=new RelationshipModel(this,der);
                    rel.setRelationType(der.getDERType()).setCodeName(codeName).setEntityId(der.getMinorPSDataEntity().getId())
                            .setEntityCodeName(der.getMinorPSDataEntity().getCodeName()).setEntityName(der.getMinorPSDataEntity().getName())
                            .setEntityLogicName(der.getMinorPSDataEntity().getLogicName()).setTableName(der.getMinorPSDataEntity().getTableName());

                    if(der.getMinorPSDataEntity().getPSSystemModule()!=null)
                        rel.setModule(der.getMinorPSDataEntity().getPSSystemModule().getCodeName().toLowerCase());

                    if(der1n.getPSOne2ManyDataDEField()!=null&&der1n.getPSOne2ManyDataDEField().isPhisicalDEField()&&der1n.getMinorPSDataEntity().getStorageMode()==0)
                    {
                        rel.setColumnName(der1n.getPSOne2ManyDataDEField().getName().toLowerCase());
                    }


                    String relfieldname=der1n.getPSPickupDEField().getObjectNode().get("getRelatedPSDEField").get("name").asText();

                    LookupModel lookupModel=new LookupModel().setRelationid(der.getId())
                            .setFieldname(der1n.getPickupDEFName()).setReffieldname(relfieldname);
                    rel.addLookup(lookupModel);

                    this.addNested(rel);
                }


            }
        }

        Map<String,FieldModel> fieldMaps=new LinkedHashMap<>();
        for(IPSDEField defield:dataEntity.getAllPSDEFields())
        {

           

            if(defield.isPasteReset())
                this.hasResetField=true;

            FieldModel fieldModel=new FieldModel(this,defield);

            try { 
                fieldModel.setDict(defield.getPSCodeList()!=null?defield.getPSCodeList().getCodeName():null);                 
            } catch (Exception ex){}

            if(defield.getAllPSDEFDTColumns()!=null)
            {
                defield.getAllPSDEFDTColumns().forEach(col->{
                    if(!fieldModel.getFieldName().equalsIgnoreCase(col.getColumnName()))
                        fieldModel.set("column-"+col.getDBType().toLowerCase().replace("mysql5","mysql"),col.getColumnName());
                    if(StringUtils.isEmpty(fieldModel)&&defield.isFormulaDEField()&&(!StringUtils.isEmpty(col.getQueryCodeExp())))
                        fieldModel.setExpression(col.getQueryCodeExp().replace("`","").replace("[","").replace("]",""));
                });
            }

            if(defield.isLinkDEField() && defield instanceof IPSLinkDEField)
            {
                IPSLinkDEField linkDEField = (IPSLinkDEField)defield;
                String relfieldname=linkDEField.getObjectNode().get("getRelatedPSDEField").get("name").asText();
                String relfieldcodename=linkDEField.getObjectNode().get("getRelatedPSDEField").get("codeName").asText();
                linkDEField.getRelatedPSDEField();
                fieldModel.setRefFieldName(relfieldname).setRefFieldCodeName(relfieldcodename);

                if(!StringUtils.isEmpty(linkDEField.getPSDER().getCodeName()))
                {
                    RelationshipModel relationshipModel=this.getRefMaps().get(linkDEField.getPSDER().getCodeName());
                    if(relationshipModel!=null&&(!StringUtils.isEmpty(relationshipModel.getCodeName()))) {
                        relationshipModel.addField(fieldModel);
                        fieldModel.setReference(relationshipModel);
                        if("PICKUP".equalsIgnoreCase(defield.getDataType()))
                            relationshipModel.setFkField(fieldModel);
                    }
                }

            }



            fieldMaps.put(fieldModel.getFieldName(),fieldModel);
            this.addField(fieldModel);
        }





        if(dataEntity.getAllPSDEDataSets()!=null)
        {
            dataEntity.getAllPSDEDataSets().forEach(dataSet->{


                try {

                    if(dataSet.getPSDEDataQueries()!=null)
                    {



                        Map<String, String> map =new HashMap<>();
                        dataSet.getPSDEDataQueries().forEach(dataQuery->{

                            try {
                                if(dataQuery.getAllPSDEDataQueryCodes()!=null)
                                {
                                    dataQuery.getAllPSDEDataQueryCodes().forEach(dq->{
                                        String code="";
                                        if(!map.containsKey(dq.getDBType())) {
                                            map.put(dq.getDBType(), "");
                                            code="";
                                        }
                                        else {
                                            code = map.get(dq.getDBType());
                                            code = code+"\r\n union all \r\n";
                                        }
                                        code = code+ TransUtils.getQueryCode(dq);
                                        ;//"<include refid=\""+this.getEntityName().toLowerCase()+"_dq_"+dataQuery.getCodeName()+"_"+dq.getDBType().toLowerCase()+"\"/>";
                                        map.put(dq.getDBType(),"select t1.* from ("+code+") t1");
                                    });
                                }
                            } catch (Exception exception) {

                            }

                        });

                        for(Map.Entry<String, String> entry:map.entrySet())
                        {
                            String sql=null;

                            if(dataSet.getGroupMode()==1||dataSet.getMajorSortPSDEField()!=null)
                            {

                                if(dataSet.getGroupMode()==1&&(!ObjectUtils.isEmpty(dataSet.getPSDEDataSetGroupParams())))
                                {
                                    sql="select ";
                                    int i=0;
                                    for(IPSDEDataSetGroupParam obj:dataSet.getPSDEDataSetGroupParams())
                                    {
                                        if(!(obj instanceof PSDEDataSetGroupParamImpl))
                                            continue;
                                        PSDEDataSetGroupParamImpl groupParam=(PSDEDataSetGroupParamImpl)obj;
                                        if(i>0)sql=sql.concat(",");
                                        if(groupParam.isEnableGroup())
                                        {
                                            if(!StringUtils.isEmpty(groupParam.getGroupCode()))
                                                sql=sql.concat(groupParam.getGroupCode());
                                            else
                                                sql=sql.concat(groupParam.getName());
                                        }
                                        else
                                            sql=sql.concat(groupParam.getGroupCode());
                                        sql=sql.concat(" as ").concat(groupParam.getName().toLowerCase());
                                        i++;
                                    }
                                    sql=sql.concat(" from  ( %s ) t1");
                                }
                                else
                                    sql="select t1.* from ( %s ) t1";


                                if(dataSet.getGroupMode()==1&&(!ObjectUtils.isEmpty(dataSet.getPSDEDataSetGroupParams())))
                                {
                                    sql=sql.concat(" group by ");
                                    int i=0;
                                    for(IPSDEDataSetGroupParam obj:dataSet.getPSDEDataSetGroupParams())
                                    {
                                        if(!(obj instanceof PSDEDataSetGroupParamImpl))
                                            continue;
                                        PSDEDataSetGroupParamImpl groupParam=(PSDEDataSetGroupParamImpl)obj;
                                        if(groupParam.isEnableGroup())
                                        {
                                            if(i>0)sql=sql.concat(",");

                                            if(!StringUtils.isEmpty(groupParam.getGroupCode()))
                                                sql=sql.concat(groupParam.getGroupCode());
                                            else
                                                sql=sql.concat(groupParam.getName());
                                            i++;
                                        }
                                    }
                                }

                                if(dataSet.getMajorSortPSDEField()!=null)
                                {
                                    IPSDEFDTColumn column = dataSet.getMajorSortPSDEField().getPSDEFDTColumn(entry.getKey().toLowerCase().replace("mysql5","mysql"),false);

                                    sql=sql.concat(" order by ").concat(column==null?dataSet.getMajorSortPSDEField().getName():column.getColumnName());
                                    if(!StringUtils.isEmpty(dataSet.getMajorSortDir()))
                                        sql=sql.concat(" ").concat(dataSet.getMajorSortDir());
                                    if(dataSet.getMinorSortPSDEField()!=null)
                                    {
                                        IPSDEFDTColumn subCol = dataSet.getMinorSortPSDEField().getPSDEFDTColumn(entry.getKey().toLowerCase().replace("mysql5","mysql"),false);

                                        sql=sql.concat(",").concat(subCol==null?dataSet.getMinorSortPSDEField().getName():subCol.getColumnName());
                                        if(!StringUtils.isEmpty(dataSet.getMinorSortDir()))
                                            sql=sql.concat(" ").concat(dataSet.getMinorSortDir());

                                    }
                                }
                            }
                            DataSetModel dsModel=new DataSetModel(this,dataSet);
                            dsModel.setDatasetId(this.getEntityName().toLowerCase()+"-ds-"+dataSet.getCodeName()+"-"+entry.getKey().toLowerCase().replace("mysql5","mysql"))
                                    .setDatasetName(dataSet.getLogicName()).setCodeName(dataSet.getCodeName())
                                    .setDsCode(entry.getValue()).setDsModel(sql);
                            this.addDataSet(dsModel);
                        }

                    }
                } catch (Exception exception) {

                }

            });


        }

        for (String dsType : dsTypes) {
            POSchema poSchema = TransUtils.EntityModelModel2PO(this, dsType);
            if (poSchema != null) {
                this.addPOSchema(dsType, poSchema);
            }
        }

        Set<String> ignoActions=new HashSet<String>(){{
            add("get");
            add("create");
            add("update");
            add("remove");
            add("save");
            add("getdraft");
            add("checkkey");
            add("createbatch");
            add("savebatch");
            add("updatebatch");
            add("removebatch");
        }};

        if(this.getDataEntity().getAllPSDEActions()!=null)
        {
            this.getDataEntity().getAllPSDEActions().forEach(item->{
                String tag=item.getCodeName().toLowerCase();
                if(ignoActions.contains(tag))
                    return;
                addAction(new DEActionModel(this,item));
            });
        }

    }

}
