package cn.ibizlab.codegen.templating.mustache;

import cn.ibizlab.codegen.utils.StringAdvUtils;
import cn.ibizlab.codegen.CodegenConfig;
import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;

import java.io.IOException;
import java.io.Writer;

import static cn.ibizlab.codegen.utils.StringAdvUtils.camelize;


/**
 * Converts text in a fragment to camelCase.
 *
 * Register:
 * <pre>
 * additionalProperties.put("camelcase", new CamelCaseLambda());
 * </pre>
 *
 * Use:
 * <pre>
 * {{#camelcase}}{{name}}{{/camelcase}}
 * </pre>
 */
public class CamelCaseLambda implements Mustache.Lambda {
    private CodegenConfig generator = null;
    private Boolean escapeParam = false;
    private Boolean lowercaseFirstLetter = true;

    public CamelCaseLambda(boolean lowercaseFirstLetter) {
      this.lowercaseFirstLetter = lowercaseFirstLetter;
    }

    public CamelCaseLambda() {}

    public CamelCaseLambda generator(final CodegenConfig generator) {
        this.generator = generator;
        return this;
    }

    public CamelCaseLambda escapeAsParamName(final Boolean escape) {
        this.escapeParam = escape;
        return this;
    }

    @Override
    public void execute(Template.Fragment fragment, Writer writer) throws IOException {
        String text = StringAdvUtils.camelize(fragment.execute(), lowercaseFirstLetter);
        if (generator != null) {
            text = generator.sanitizeName(text);

        }
        writer.write(text);
    }


}
