package cn.ibizlab.codegen.model;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import net.ibizsys.model.dataentity.service.IPSDEMethodDTO;
import net.ibizsys.model.dataentity.service.IPSDEServiceAPI;

import java.util.*;

@Getter
@Setter
@NoArgsConstructor
@Accessors(chain = true)
public class ApiEntityModel extends BaseModel {

    public ApiEntityModel(ApiModel apiModel, IPSDEServiceAPI apiDataEntity) {
        this.opt = apiDataEntity;
        this.api = apiModel;
        this.setCodeName(apiDataEntity.getCodeName());
        this.setName(apiDataEntity.getName());
        this.setId(String.format("%1$s-%2$s", api.getCodeName(), apiDataEntity.getCodeName()));
        if (apiDataEntity.getPSDataEntity() != null && apiDataEntity.getPSDataEntity().getAllPSDEMethodDTOs() != null) {
            for (IPSDEMethodDTO iPSDEMethodDTO : apiDataEntity.getPSDataEntity().getAllPSDEMethodDTOs()) {
                apiDtosMap.put(iPSDEMethodDTO.getName(), new ApiDtoModel(this,iPSDEMethodDTO));
            }
        }
    }

    public IPSDEServiceAPI getApiDataEntity() {
        return (IPSDEServiceAPI) opt;
    }

    private ApiModel api;

    public EntityModel getEntity() {
        return api.getSystem().getEntity(getApiDataEntity().getPSDataEntity().getCodeName());
    }

    private List<FieldModel> properties;

    public List<FieldModel> getProperties() {
        if (properties == null) {
            properties = new ArrayList<>();
            getEntity().getFields().forEach(field -> {
                properties.add(field);
            });
        }
        return properties;
    }

    private Map<String, ApiDtoModel> apiDtosMap = new LinkedHashMap<>();

    public Collection<ApiDtoModel> getDtos() {
        return apiDtosMap.values();
    }

}
