package cn.ibizlab.codegen.model;

import cn.ibizlab.codegen.utils.Inflector;
import com.alibaba.fastjson.JSONObject;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import net.ibizsys.model.app.IPSApplication;

import java.util.*;

@Getter
@Setter
@NoArgsConstructor
@Accessors(chain = true)
public class AppModel extends BaseModel{

    public AppModel(IPSApplication application)
    {
        this.opt=application;
        this.setCodeName(application.getCodeName());
        this.setName(application.getName());
        if(getApplication().getAllPSAppDataEntities()!=null)
        {
            getApplication().getAllPSAppDataEntities().forEach(item->{
                appEntitiesMap.put(item.getCodeName(),new AppEntityModel(this,item));
            });
        }
        if(getApplication().getAllPSAppViews()!=null)
        {
            getApplication().getAllPSAppViews().forEach(item->{
                if(item.getRefFlag()) {
                    pagesMap.put(item.getCodeName(), new PageModel(this, item));
                }
            });
        }

        // 初始化应用实体资源数据Map
        if(getApplication().getAllPSAppDataEntities()!=null)
        {
            getApplication().getAllPSAppDataEntities().forEach(appDataEntity ->{

                if(appDataEntity.getMinorPSAppDERSs() != null){
                    appDataEntity.getMinorPSAppDERSs().forEach(appDERS ->{
                        JSONObject tempObj = new JSONObject();
                        String majorCodeName = appDERS.getMajorPSAppDataEntity().getCodeName();
                        String minorCodeName = appDERS.getMinorPSAppDataEntity().getCodeName();
                        String path = String.format("%1$s/:%2$s?/%3$s/:%4$s?",Inflector.getInstance().pluralize(majorCodeName),majorCodeName,Inflector.getInstance().pluralize(minorCodeName),minorCodeName).toLowerCase();
                        tempObj.put("majorCodeName",majorCodeName.toLowerCase());
                        tempObj.put("curCodeName",minorCodeName.toLowerCase());
                        tempObj.put("path",path);
                        tempObj.put("appDataEntity",appDataEntity);
                        appEntityResourceMap.put(String.format("%1$s:%2$s",majorCodeName,minorCodeName),tempObj);
                    });
                }else{
                    JSONObject tempObj = new JSONObject();
                    tempObj.put("curCodeName",appDataEntity.getCodeName().toLowerCase());
                    tempObj.put("path",String.format("%1$s/:%2$s?",Inflector.getInstance().pluralize(appDataEntity.getCodeName()),appDataEntity.getCodeName()).toLowerCase());
                    tempObj.put("appDataEntity",appDataEntity);
                    appEntityResourceMap.put(appDataEntity.getCodeName(),tempObj);
                }
            });
        }

    }


    private SystemModel system;

    public IPSApplication getApplication()
    {
        return (IPSApplication)opt;
    }

    private Map<String,AppEntityModel> appEntitiesMap=new LinkedHashMap<>();

    private Map<String,PageModel> pagesMap=new LinkedHashMap<>();

    private Map<String,CtrlModel> ctrlsMap=new LinkedHashMap<>();


    public Collection<AppEntityModel> getAppEntities() {
        return appEntitiesMap.values();
    }

    public Collection<PageModel> getPages() {
        return pagesMap.values();
    }

    public Collection<CtrlModel> getCtrls() {
        return ctrlsMap.values();
    }



    public PageModel getPage(String codeName)
    {
        if(pagesMap!=null)
            return pagesMap.get(codeName);
        return null;
    }

    public AppEntityModel getAppEntity(String codeName)
    {
        if(appEntitiesMap!=null)
            return appEntitiesMap.get(codeName);
        return null;
    }

    /**
     * 应用实体资源数据Map
     */
    private Map<String, JSONObject> appEntityResourceMap =new LinkedHashMap<>();

    /**
     * 获取应用实体资源数据
     * @return
     */
    public Collection<JSONObject> getAppEntityResources(){
        if(appEntityResourceMap!=null)
            return appEntityResourceMap.values();
        return new ArrayList<>();
    }

}
