package cn.ibizlab.util.service;

import cn.ibizlab.util.annotation.Audit;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.domain.IBZDataAuditItem;
import cn.ibizlab.util.helper.BeanCache;
import cn.ibizlab.util.security.AuthenticationUser;
import lombok.SneakyThrows;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.scheduling.annotation.Async;
import org.springframework.util.ObjectUtils;

import javax.servlet.http.HttpServletRequest;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 实体[DataAudit] 服务对象接口
 */
public interface IBZDataAuditService {
    @Async("asyncExecutor")
    void createAudit(HttpServletRequest request, EntityBase entity, Object idValue);
    @Async("asyncExecutor")
    void updateAudit(HttpServletRequest request, EntityBase beforeEntity, EntityBase entity, Object idValue);
    @Async("asyncExecutor")
    void removeAudit(HttpServletRequest request, EntityBase entity, Object idValue);

    default List<IBZDataAuditItem> getAuditInfo(EntityBase entity) {
        List<IBZDataAuditItem> auditFieldArray = new ArrayList<>();
        BeanCache.get(entity.getClass()).getAudits().forEach(item->{
            String fieldName = item.getCodeName();
            DEField deField = item.getDeField();
            Object value = dataTransfer(entity.get(fieldName),item.getFormat());
            if(!ObjectUtils.isEmpty(value)) {
                IBZDataAuditItem auditFieldObj = new IBZDataAuditItem();
                auditFieldObj.setId(item.getJsonName());
                auditFieldObj.setLabel(item.getLogicName());
                auditFieldObj.setValue(value);
                if(!ObjectUtils.isEmpty(deField)&&!ObjectUtils.isEmpty(deField.dict())) {
                    auditFieldObj.setDict(deField.dict());
                }
                auditFieldArray.add(auditFieldObj);
            }
        });
        if(auditFieldArray.size()>0) {
            return auditFieldArray;
        }
        return null;
    }

    default List<IBZDataAuditItem> getUpdateAuditInfo(EntityBase oldData, EntityBase newData){
        List<IBZDataAuditItem> auditFieldArray = new ArrayList<>();
        BeanCache.get(oldData.getClass()).getAudits().forEach(item->{
            String fieldName = item.getCodeName();
            DEField deField = item.getDeField();
            Object oldValue = oldData.get(fieldName);//老属性值
            Object newValue = newData.get(fieldName);//新属性值
            if(!compare(oldValue, newValue)) {


                IBZDataAuditItem auditFieldObj = new IBZDataAuditItem();
                auditFieldObj.setId(item.getJsonName());
                auditFieldObj.setLabel(item.getLogicName());
                auditFieldObj.setValue(dataTransfer(newValue, deField.format()));
                auditFieldObj.setBefore(dataTransfer(oldValue, deField.format()));

                if(!ObjectUtils.isEmpty(deField)&&!ObjectUtils.isEmpty(deField.dict())) {
                    auditFieldObj.setDict(deField.dict());
                }
                auditFieldArray.add(auditFieldObj);
            }
        });
        if(auditFieldArray.size()>0) {
            return auditFieldArray;
        }
        return null;
    }


    default Object dataTransfer(Object value, String strFormat) {
        if(value==null) {
            return "";
        }
        Object transResult=value;
        if( (!ObjectUtils.isEmpty(strFormat)) && value instanceof Timestamp) {  //时间类型转换
            Timestamp timestamp = (Timestamp)value;
            SimpleDateFormat format = new SimpleDateFormat(strFormat);
            transResult = format.format(timestamp);
        }
        return transResult;
    }

    /**
     * 对象比较
     * @param sourceObj 比较源对象
     * @param targetObj 比较目标对象
     * @return
     */
    default boolean compare(Object sourceObj, Object targetObj) {
        if(sourceObj == null && targetObj == null) {
            return true;
        }
        if(sourceObj == null && targetObj != null) {
            return false;
        }
        return sourceObj.equals(targetObj);
    }


    /**
     * 获取Ip地址
     * @param request
     * @return
     */
    default String getIpAddress(HttpServletRequest request, AuthenticationUser authenticationUser) {
        //客户端有提交ip，以提交的ip为准
        if(authenticationUser != null && !ObjectUtils.isEmpty(authenticationUser.getAddr())) {
            return authenticationUser.getAddr();
        }
        if(request == null) {
            return "";
        }
        String Xip = request.getHeader("X-Real-IP");
        String XFor = request.getHeader("X-Forwarded-For");
        if(!ObjectUtils.isEmpty(XFor) && !"unKnown".equalsIgnoreCase(XFor)) {
            //多次反向代理后会有多个ip值，第一个ip才是真实ip
            int index = XFor.indexOf(",");
            if(index != -1){
                return XFor.substring(0,index);
            }else{
                return XFor;
            }
        }
        XFor = Xip;
        if(!ObjectUtils.isEmpty(XFor) && !"unKnown".equalsIgnoreCase(XFor)) {
            return XFor;
        }
        if (ObjectUtils.isEmpty(XFor) || "unknown".equalsIgnoreCase(XFor)) {
            XFor = request.getHeader("Proxy-Client-IP");
        }
        if (ObjectUtils.isEmpty(XFor) || "unknown".equalsIgnoreCase(XFor)) {
            XFor = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ObjectUtils.isEmpty(XFor) || "unknown".equalsIgnoreCase(XFor)) {
            XFor = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ObjectUtils.isEmpty(XFor) || "unknown".equalsIgnoreCase(XFor)) {
            XFor = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ObjectUtils.isEmpty(XFor) || "unknown".equalsIgnoreCase(XFor)) {
            XFor = request.getRemoteAddr();
        }
        return XFor;
    }
}