package cn.ibizlab.util.service;

import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.domain.IBZConfig;
import cn.ibizlab.util.domain.IEntity;
import cn.ibizlab.util.errors.BadRequestAlertException;
import cn.ibizlab.util.helper.BeanCache;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.mapper.IBZConfigMapper;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.reflections.Reflections;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import javax.annotation.PostConstruct;
import java.util.ServiceLoader;
import java.util.Set;

@Slf4j
@Service
public class IBZConfigService extends ServiceImpl<IBZConfigMapper, IBZConfig> implements IService<IBZConfig> {

    @PostConstruct
    public void init() {
        Reflections reflections = new Reflections();
        Set<Class<? extends EntityBase>> subClazzs = reflections.getSubTypesOf(EntityBase.class);
        subClazzs.forEach(entity->{
            BeanCache.register(entity);
        });
    }

    @Value("${ibiz.systemid:ibznotify}")
	private String systemId;

    @Value("${ibiz.admin.userid:0100}")
    private String adminuserid;

    @Cacheable(value="ibzrt_configs",key = "'cfgid:'+#p0+'||'+#p1+'||'+#p2")
    public JSONObject getConfig(String cfgType,String targetType,String userId)
    {
        if(ObjectUtils.isEmpty(userId) || ObjectUtils.isEmpty(cfgType) || ObjectUtils.isEmpty(targetType)) {
            throw new BadRequestAlertException("获取配置失败，参数缺失","IBZConfig",cfgType);
        }
        IBZConfig builder=new IBZConfig();
        builder.setSystemId(systemId);
        builder.setCfgType(cfgType);
        builder.setTargetType(targetType);
        builder.setUserId(userId);
        IBZConfig config = this.getOne(Wrappers.query(builder), false);
        if(config == null) {
            builder.setUserId(adminuserid);
            config = this.getOne(Wrappers.query(builder), false);
            if(config == null) {
                return new JSONObject();
            }
        }
        return JSON.parseObject(config.getCfg());
    }

    @CacheEvict(value="ibzrt_configs", key = "'cfgid:'+#p0+'||'+#p1+'||'+#p2")
    public boolean saveConfig(String cfgType, String targetType, String userId, JSONObject config)
    {
        if(ObjectUtils.isEmpty(userId) || ObjectUtils.isEmpty(cfgType) || ObjectUtils.isEmpty(targetType)) {
            throw new BadRequestAlertException("保存配置失败，参数缺失","IBZConfig",cfgType);
        }
        String cfg = "{}";
        if(config != null) {
            cfg = JSONObject.toJSONString(config);
        }
        IBZConfig builder=new IBZConfig();
        builder.setSystemId(systemId);
        builder.setCfgType(cfgType);
        builder.setTargetType(targetType);
        builder.setUserId(userId);
        builder.setCfg(cfg);
        builder.setUpdateDate(DataObject.getNow());
        builder.getCfgId();
        return this.saveOrUpdate(builder);
    }

    @CacheEvict(value = "ibzrt_configs", key = "'cfgid:'+#p0+'||'+#p1+'||'+#p2")
    public void resetConfig(String cfgType, String targetType, String userId)
    {
        if(ObjectUtils.isEmpty(userId) || ObjectUtils.isEmpty(cfgType) || ObjectUtils.isEmpty(targetType)) {
            throw new BadRequestAlertException("重置配置失败，参数缺失","IBZConfig",cfgType);
        }
        IBZConfig builder=new IBZConfig();
        builder.setSystemId(systemId);
        builder.setCfgType(cfgType);
        builder.setTargetType(targetType);
        builder.setUserId(userId);
        this.remove(Wrappers.query(builder));
    }

    @Cacheable(value="ibzrt_shareconfigs",key = "'cfgid:'+#p0")
    public JSONObject saveShareConfig(String id, String cfgType,String targetType,String userId){
        return this.getConfig(cfgType, targetType, adminuserid);
    }

    @Cacheable(value="ibzrt_shareconfigs",key = "'cfgid:'+#p0")
    public JSONObject getShareConfig(String id){
        return null;
    }

}