package cn.ibizlab.util.helper;

import cn.ibizlab.util.domain.EntityBase;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.FatalBeanException;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class CachedBeanCopier {

    public static void copy(Object srcObj, Object destObj) {
        copy(srcObj, destObj, false);
    }

    public static void copy(Object srcObj, Object destObj, boolean useConverter) {
        if (srcObj == null || destObj == null) {
            return;
        }
        BeanUtils.copyProperties(srcObj, destObj);
    }

    public static void copyWithFocusNull(EntityBase source, EntityBase target) {
        if (source == null || target == null) {
            return;
        }
        Class<?> actualEditable = target.getClass();
        Class<?> sourceClass = source.getClass();
        PropertyDescriptor[] targetPds = BeanUtils.getPropertyDescriptors(actualEditable);
        for (PropertyDescriptor targetPd : targetPds) {
            if (targetPd.getWriteMethod() == null) {
                continue;
            }
            PropertyDescriptor sourcePd = BeanUtils.getPropertyDescriptor(sourceClass, targetPd.getName());
            if (sourcePd == null || sourcePd.getReadMethod() == null) {
                continue;
            }
            try {
                Method readMethod = sourcePd.getReadMethod();
                if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                    readMethod.setAccessible(true);
                }
                Object value = readMethod.invoke(source);
                if (value == null) {
                    if (source.getFocusNull().contains(sourcePd.getName().toLowerCase())) {
                        setValue(target, targetPd, value);
                    }
                } else {
                    setValue(target, targetPd, value);
                }

            } catch (Exception ex) {
                throw new FatalBeanException("Could not copy properties from source to target", ex);
            }
        }
    }

    private static void setValue(Object target, PropertyDescriptor targetPd, Object value) throws IllegalAccessException, InvocationTargetException {
        Method writeMethod = targetPd.getWriteMethod();
        if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
            writeMethod.setAccessible(true);
        }
        writeMethod.invoke(target, value);
    }

}
