package cn.ibizlab.util.service;

import cn.ibizlab.util.dict.Option;
import cn.ibizlab.util.domain.IBZDataAuditItem;
import cn.ibizlab.util.helper.BeanCache;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import cn.ibizlab.util.annotation.Audit;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.domain.IBZDataAudit;
import cn.ibizlab.util.mapper.IBZDataAuditMapper;
import cn.ibizlab.util.security.AuthenticationUser;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import javax.servlet.http.HttpServletRequest;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 实体[DataAudit] 服务对象接口实现
 */
@Service
@Slf4j
public class SimpleAuditService extends ServiceImpl<IBZDataAuditMapper, IBZDataAudit> implements IBZDataAuditService {


    private static List cacheMap = Collections.synchronizedList(new ArrayList());
    /**
     * 定时保存审计记录
     */
    @Scheduled(fixedRate = 10000)
    public void saveAudit() {
        if(cacheMap.size()>0) {
            log.info(String.format("正在保存审计数据，当前审计集合数量为[%s]",cacheMap.size()));
            List temp=new ArrayList();
            if(cacheMap.size()<500) {
              temp.addAll(cacheMap);
            }
            else {
              temp.addAll(cacheMap.subList(0,500));
            }
            this.saveBatch(temp);
            cacheMap.removeAll(temp);
            log.info(String.format("保存完成，当前审计集合数量为[%s]",cacheMap.size()));
        }
    }


    @Override
    public void createAudit(HttpServletRequest request, EntityBase entity, Object idValue) {
        if(ObjectUtils.isEmpty(idValue))
            idValue=entity.get(BeanCache.getKeyField(entity.getClass()));
        IBZDataAudit dataAudit = new IBZDataAudit();
        dataAudit.setOpPersonId(AuthenticationUser.getAuthenticationUser().getUserid());
        dataAudit.setOpPersonName(String.format("%s[%s]", AuthenticationUser.getAuthenticationUser().getPersonname(), AuthenticationUser.getAuthenticationUser().getOrgname()));
        dataAudit.setAuditType("CREATE");
        dataAudit.setAuditObject(BeanCache.get(entity.getClass()).getCodeName());
        dataAudit.setDataAuditName(BeanCache.get(entity.getClass()).getLogicName()+"[新建]");
        dataAudit.setAuditObjectData(idValue);
        dataAudit.setOpTime(new Timestamp(System.currentTimeMillis()));
        if(request != null) {
            dataAudit.setIpAddress(getIpAddress(request, AuthenticationUser.getAuthenticationUser()));
        }
        dataAudit.setAuditInfo(getAuditInfo(entity));
        dataAudit.setIsDataChanged(1);
        cacheMap.add(dataAudit);
    }


    @SneakyThrows
    public void updateAudit(HttpServletRequest request, EntityBase beforeEntity, EntityBase afterEntity, Object idValue) {
        if(ObjectUtils.isEmpty(idValue))
            idValue=beforeEntity.get(BeanCache.getKeyField(beforeEntity.getClass()));
        //获取更新后的审计内容
        List<IBZDataAuditItem> auditInfo = getUpdateAuditInfo(beforeEntity, afterEntity);//比较更新前后差异内容
        int isDataChanged = 1;
        //审计内容是否发生变化
        if(ObjectUtils.isEmpty(auditInfo)) {
            isDataChanged = 0;
        }
        IBZDataAudit dataAudit = new IBZDataAudit();
        dataAudit.setOpPersonId(AuthenticationUser.getAuthenticationUser().getUserid());
        dataAudit.setOpPersonName(String.format("%s[%s]", AuthenticationUser.getAuthenticationUser().getPersonname(), AuthenticationUser.getAuthenticationUser().getOrgname()));
        dataAudit.setAuditType("UPDATE");
        dataAudit.setAuditObject(BeanCache.get(beforeEntity.getClass()).getCodeName());
        dataAudit.setDataAuditName(BeanCache.get(beforeEntity.getClass()).getLogicName()+"[更新]");
        dataAudit.setAuditObjectData(idValue);
        dataAudit.setOpTime(new Timestamp(System.currentTimeMillis()));
        if(request != null) {
            dataAudit.setIpAddress(getIpAddress(request, AuthenticationUser.getAuthenticationUser()));
        }
        dataAudit.setAuditInfo(auditInfo);
        dataAudit.setIsDataChanged(isDataChanged);
        cacheMap.add(dataAudit);
    }


    public void removeAudit(HttpServletRequest request, EntityBase entity, Object idValue) {
        if(ObjectUtils.isEmpty(idValue))
            idValue=entity.get(BeanCache.getKeyField(entity.getClass()));
        IBZDataAudit dataAudit = new IBZDataAudit();
        dataAudit.setOpPersonId(AuthenticationUser.getAuthenticationUser().getUserid());
        dataAudit.setOpPersonName(String.format("%s[%s]", AuthenticationUser.getAuthenticationUser().getPersonname(), AuthenticationUser.getAuthenticationUser().getOrgname()));
        dataAudit.setAuditType("REMOVE");
        dataAudit.setAuditObject(BeanCache.get(entity.getClass()).getCodeName());
        dataAudit.setDataAuditName(BeanCache.get(entity.getClass()).getLogicName()+"[删除]");
        dataAudit.setAuditObjectData(idValue);
        dataAudit.setOpTime(new Timestamp(System.currentTimeMillis()));
        if(request != null) {
            dataAudit.setIpAddress(getIpAddress(request, AuthenticationUser.getAuthenticationUser()));
        }
        dataAudit.setIsDataChanged(1);
        cacheMap.add(dataAudit);
    }



}