package cn.ibizlab.util.service;

import cn.ibizlab.util.client.IBZUAAFeignClient;
import cn.ibizlab.util.errors.BadRequestAlertException;
import cn.ibizlab.util.errors.UnauthorizedException;
import cn.ibizlab.util.helper.BeanCache;
import cn.ibizlab.util.security.*;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.stereotype.Service;
import org.springframework.util.DigestUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.*;
import java.util.stream.Collectors;

@Slf4j
@Service("CloudUserService")
@ConditionalOnExpression("'${ibiz.auth.service:IBZUAAUserService}'.equals('CloudUserService')")
public class CloudUserService extends IBZUAAUserService {

    @Autowired
    @Lazy
    private RedisTemplate redisTemplate;


    @Value("${ibiz.enablePermissionValid:false}")
    boolean enablePermissionValid;  //是否开启权限校验

    @Value("${ibiz.systemid}")
    public String systemId;

    @Override
    public boolean isEnablePermissionValid() {
        return enablePermissionValid;
    }

    @Override
    public String getSystemId() {
        return systemId;
    }

    @Value("${ibiz.jwt.header:Authorization}")
    private String tokenHeader;

    private ObjectMapper objectMapper=new ObjectMapper();

    private TypeReference<Collection<UAAGrantedAuthority>> UAAGrantedAuthorityListType =  new TypeReference<Collection<UAAGrantedAuthority>>(){};

    @Override
    @Cacheable( value="ibzuaa_users", key = "#root.target.systemId+':getByUsername:'+#p0")
    public AuthenticationUser loadUserByUsername(String username) {
        Object obj = redisTemplate.opsForValue().get("ibiz-cloud-uaa-user-" + username);
        if (obj == null) {
            throw new BadRequestAlertException("登录失败", "CloudUser", username);
        }
        try {
            AuthenticationUser dcEmployee = objectMapper.readValue(objectMapper.writeValueAsBytes(obj), AuthenticationUser.class);


            ServletRequestAttributes requestAttributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
            if (requestAttributes != null) {
                HttpServletRequest request = requestAttributes.getRequest();
                final String requestHeader = request.getHeader(this.tokenHeader);
                if (requestHeader != null && requestHeader.startsWith("Bearer ")) {
                    String authToken = requestHeader.substring(7);
                    // 重新计算用户标识
                    String srforgid = request.getHeader("srforgid");
                    String srfsystemid = request.getHeader("srfsystemid");
                    String srfdcsystemid = request.getHeader("srfdcsystemid");
                    String srfuserid = request.getHeader("srfuserid");
                    String srfdcid = request.getHeader("srfdcid");

                    if ("undefined".equals(srfsystemid)) {
                        srfsystemid = null;
                    }
                    if ("undefined".equals(srforgid)) {
                        srforgid = null;
                    }

                    Collection authorities = null;
                    if (StringUtils.hasLength(srfsystemid)
                            && StringUtils.hasLength(srfdcid) && StringUtils.hasLength(srfdcsystemid) && StringUtils.hasLength(srfuserid)) {

                        //可以没有组织
                        //&& StringUtils.hasLength(srforgid)

                        if ((dcEmployee.getApiuser() == 1)
                                || (dcEmployee.getSuperuser() == 1)) {
                            String srfusername = request.getHeader("srfusername");
                            //接口用户用传入身份构造EMP
                            dcEmployee.setSrfdcid(srfdcid);
                            dcEmployee.setUserid(srfuserid);
                            dcEmployee.setDcsystemid(srfdcsystemid);
                            if (StringUtils.hasLength(srfusername)) {
                                try {
                                    dcEmployee.setPersonname(URLDecoder.decode(srfusername, "UTF-8"));
                                } catch (Exception ex) {
                                    log.error(ex.getMessage());
                                    dcEmployee.setPersonname(srfusername);
                                }
                            }
                            dcEmployee.setOrgid(srforgid);

                            String strValue = request.getHeader("srforgcode");
                            if (StringUtils.hasLength(strValue)) {
                                dcEmployee.setOrgcode(strValue);
                            }
                            strValue = request.getHeader("srfdeptid");
                            if (StringUtils.hasLength(strValue)) {
                                dcEmployee.setMdeptid(strValue);
                            }
                            strValue = request.getHeader("srfdeptcode");
                            if (StringUtils.hasLength(strValue)) {
                                dcEmployee.setMdeptcode(strValue);
                            }
                            strValue = request.getHeader("srfporgids");
                            if (StringUtils.hasLength(strValue)) {
                                dcEmployee.setPorg(strValue);
                            }
                            strValue = request.getHeader("srfsorgids");
                            if (StringUtils.hasLength(strValue)) {
                                dcEmployee.setSorg(strValue);
                            }
                            strValue = request.getHeader("srfpdeptids");
                            if (StringUtils.hasLength(strValue)) {
                                dcEmployee.setPdept(strValue);
                            }
                            strValue = request.getHeader("srfsdeptids");
                            if (StringUtils.hasLength(strValue)) {
                                dcEmployee.setSdept(strValue);
                            }

                        } else {
                            log.error(String.format("用户[%1$s][%2$s]使用API模式访问系统", dcEmployee.getUserid(), dcEmployee.getUsername()));
                            throw new UnauthorizedException(String.format("用户[%1$s][%2$s]使用API模式访问系统", dcEmployee.getUserid(), dcEmployee.getUsername()));
                        }
                    } else if (StringUtils.hasLength(srfsystemid) && StringUtils.hasLength(srforgid)) {
                        uaaFeignClient.getAppData();
                        AuthenticationUser employee = this.getEmployee(srfsystemid, srforgid, dcEmployee.getUsername(), authToken);
                        if (employee != null ) {
                            if(dcEmployee.getSuperuser() == 1)
                                employee.setSuperuser(1);
                            dcEmployee=employee;
                        }
                        String strDCSystemId = null;
                        if (dcEmployee != null) {
                            strDCSystemId = dcEmployee.getDcsystemid();
                        }
                        if (StringUtils.hasLength(strDCSystemId)) {
                            authorities = this.getGrantedAuthorities(strDCSystemId, dcEmployee.getUsername(), authToken);
                            if(!ObjectUtils.isEmpty(authorities)) {
                                if(dcEmployee.getSuperuser() == 1){
                                    authorities.add( "ROLE_SUPERADMIN");
                                }
                                Map permission =new HashMap();
                                permission.put("authorities",authorities);
                                dcEmployee.setPermissionList(permission);
                            }
                        }
                    }
                }


            }
            return dcEmployee;
        } catch (IOException e) {
            throw new BadRequestAlertException("登录失败", "CloudUser", username);
        }
    }


    protected Collection getGrantedAuthorities(String strDCSystemId, String strUAAUserName, String strToken){
        String strCacheCat = String.format("ibiz-cloud-uaa-cat-%1$s--%2$s",  strUAAUserName, DigestUtils.md5DigestAsHex(strToken.getBytes(StandardCharsets.UTF_8)));;
        String strCacheTag = String.format("authorities-%1$s", strDCSystemId);
        Object obj =  this.redisTemplate.opsForHash().get(strCacheCat, strCacheTag);
        if(!ObjectUtils.isEmpty(obj)) {
            try {
                Map<String,Object> rt=new LinkedHashMap<>();
                Collection<UAAGrantedAuthority> tmp =  objectMapper.readValue(objectMapper.writeValueAsString(obj), this.UAAGrantedAuthorityListType);
                if(!ObjectUtils.isEmpty(tmp))
                {
                    tmp.forEach(item->{
                        if(item instanceof UAADEAuthority)
                        {
                            UAADEAuthority deAuth=(UAADEAuthority)item;
                            deAuth.setEntityCode(BeanCache.get(deAuth.getEntity()).getCodeName());
                            if(ObjectUtils.isEmpty(deAuth.getEntityCode()))
                                return;
                            deAuth.getAuthorities().forEach(auth->{
                                if(auth.endsWith("-custom"))
                                {
                                    UAACustomAuthority customAuthority=new UAACustomAuthority();
                                    customAuthority.setSystemid(deAuth.getSystemid());
                                    customAuthority.setEntity(deAuth.getEntity());
                                    customAuthority.setEntityCode(deAuth.getEntityCode());
                                    customAuthority.setBscope(deAuth.getBscope());
                                    customAuthority.setAuthority(DigestUtils.md5DigestAsHex((auth+deAuth.getBscope()).getBytes()));
                                    rt.put(customAuthority.getAuthority(),customAuthority);
                                }
                                else
                                {
                                    rt.put(auth,auth);
                                }

                            });
                        }
                        else
                        {
                            rt.put(item.getAuthority(),item.getAuthority());
                        }
                    });
                    return rt.values().stream().collect(Collectors.toList());
                }

            } catch (IOException e) {

            }
        }
        return null;
    }

    protected AuthenticationUser getEmployee(String strSystemId, String strOrgId, String strUAAUserName, String strToken) {
        String strCacheCat = String.format("ibiz-cloud-uaa-cat-%1$s--%2$s",  strUAAUserName, DigestUtils.md5DigestAsHex(strToken.getBytes(StandardCharsets.UTF_8)));;
        String strCacheTag = String.format("sysemp-%1$s--%2$s", strSystemId, strOrgId);
        Object obj =  this.redisTemplate.opsForHash().get(strCacheCat, strCacheTag);
        if(!ObjectUtils.isEmpty(obj)) {
            try {
                return  objectMapper.readValue(objectMapper.writeValueAsString(obj), AuthenticationUser.class);
            } catch (IOException e) {

            }
        }
        return null;
    }

    @Autowired
    private IBZUAAFeignClient uaaFeignClient;

    @Override
    public Map getAppData() {
        Map appData = uaaFeignClient.getAppData();
        return ObjectUtils.isEmpty(appData)?super.getAppData():appData;
    }

    @Override
    @CacheEvict( value="ibzuaa_users", key = "'glob:*getByUsername:'+#p0")
    public void resetByUsername(String username) {
    }
}
