package cn.ibizlab.util.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.AbstractJsonTypeHandler;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;
import org.springframework.data.annotation.Id;

import java.io.IOException;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * 实体[DataAudit] 数据对象
 */
@TableName(value = "IBZDATAAUDIT")
@JsonIgnoreProperties(ignoreUnknown = true)
@Data
public class IBZDataAudit implements Serializable{

    @Id
    @TableId(type=IdType.ASSIGN_ID)//指定主键生成策略
    private String dataAuditId;
    private String dataAuditName;
    private String opPersonId;
    private String opPersonName;
    private String auditType;
    private Timestamp opTime;
    private String ipAddress;

    @TableField(typeHandler = cn.ibizlab.util.domain.IBZDataAudit.IBZDataAuditItemTypeHandler.class)
    private List<IBZDataAuditItem> auditInfo;
    private Object auditObjectData;
    private String auditObject;
    private int isDataChanged;


    @Slf4j
    @MappedTypes({List.class})
    @MappedJdbcTypes(JdbcType.VARCHAR)
    public static class IBZDataAuditItemTypeHandler extends AbstractJsonTypeHandler<List>
    {
        private static ObjectMapper objectMapper = new ObjectMapper();
        private JavaType type;

        public IBZDataAuditItemTypeHandler(Class<List> type) {
            this.type = objectMapper.getTypeFactory().constructParametricType(ArrayList.class, IBZDataAuditItem.class);
        }

        @Override
        protected List parse(String json) {
            try {
                return objectMapper.readValue(json, type);
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        protected String toJson(List obj) {
            try {
                return objectMapper.writeValueAsString(obj);
            } catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }

        public static void setObjectMapper(ObjectMapper objectMapper) {
            IBZDataAuditItemTypeHandler.objectMapper = objectMapper;
        }
    }
}