package cn.ibizlab.util.domain;

import cn.ibizlab.util.helper.BeanCache;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class EntityMP extends EntityBase {

    public UpdateWrapper getUpdateWrapper(boolean clean) {
        UpdateWrapper wrapper=new UpdateWrapper();
        for(String nullField:getFocusNull()) {
            String columnName=BeanCache.getFieldColumnName(this.getClass(),nullField);
            if(!ObjectUtils.isEmpty(columnName))
                wrapper.set(columnName,null);
        }
        if(clean) {
            getFocusNull().clear();
        }
        return  wrapper;
    }

    @Override
    public void modify(String field,Object val) {
        if(val==null) {
            this.getFocusNull().add(field.toLowerCase());
        }
        else {
            this.getFocusNull().remove(field.toLowerCase());
        }
    }

    @Override
    public void reset(String field){
        if(!ObjectUtils.isEmpty(field)){
            String resetField=field.toLowerCase();
            this.set(resetField,null);
            getFocusNull().remove(resetField);
        }
    }
}

