package cn.ibizlab.util.rest;

import cn.ibizlab.util.errors.BadRequestAlertException;
import cn.ibizlab.util.service.IBZConfigService;
import com.alibaba.fastjson.JSONObject;
import cn.ibizlab.util.security.AuthenticationUser;
import cn.ibizlab.util.service.AuthenticationUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import java.util.*;

@RestController
@RequestMapping(value = "")
public class ConfigController {


    @Autowired
	private IBZConfigService ibzConfigService;

	@RequestMapping(method = RequestMethod.PUT, value = "/configs/{configType}/{targetType}")
	public ResponseEntity<Boolean> saveConfig(@PathVariable("configType") String configType, @PathVariable("targetType") String targetType, @RequestBody JSONObject config) {
		String userId=AuthenticationUser.getAuthenticationUser().getUserid();
		if(ObjectUtils.isEmpty(userId)){
			throw new BadRequestAlertException("保存配置失败，参数缺失","IBZConfig",configType);
		}
		return ResponseEntity.ok(ibzConfigService.saveConfig(configType,targetType,userId,config));
	}

	@RequestMapping(method = RequestMethod.GET, value = "/configs/{configType}/{targetType}")
	public ResponseEntity<JSONObject> getConfig(@PathVariable("configType") String configType, @PathVariable("targetType") String targetType) {
		String userId=AuthenticationUser.getAuthenticationUser().getUserid();
		if(ObjectUtils.isEmpty(userId)){
			throw new BadRequestAlertException("获取配置失败，参数缺失","IBZConfig",configType);
		}
		return ResponseEntity.ok(ibzConfigService.getConfig(configType,targetType,userId));
	}

	@RequestMapping(method = RequestMethod.GET, value = "/configs/share/{id}")
	public ResponseEntity<JSONObject> getShareConfig(@PathVariable("id") String id) {
		JSONObject jo = ibzConfigService.getShareConfig(id);
		if (jo == null) {
			throw new BadRequestAlertException("无效的共享配置数据", "IBZConfig", id);
		}
		return ResponseEntity.ok(jo);
	}

	@RequestMapping(method = RequestMethod.GET, value = "/configs/share/{configType}/{targetType}")
	public ResponseEntity<String> shareConfig(@PathVariable("configType") String configType, @PathVariable("targetType") String targetType) {
		String userId = AuthenticationUser.getAuthenticationUser().getUserid();
		if (ObjectUtils.isEmpty(userId)) {
			throw new BadRequestAlertException("分享配置失败，参数缺失", "IBZConfig", configType);
		}
		String id = IdWorker.get32UUID();
		ibzConfigService.saveShareConfig(id, configType, targetType, userId);
		return ResponseEntity.ok(id);
	}

	/**
	* 应用参数扩展
	* @param appData
	*/
	protected void fillAppData(JSONObject appData){

	}
}
