package cn.ibizlab.util.repository;

import cn.ibizlab.util.domain.EntityMongo;
import cn.ibizlab.util.filter.MongoQueryContext;
import cn.ibizlab.util.helper.CachedBeanCopier;
import org.springframework.data.domain.Page;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.repository.query.MongoEntityInformation;
import org.springframework.data.mongodb.repository.support.SimpleMongoRepository;
import org.springframework.data.support.PageableExecutionUtils;

import java.util.List;
import java.util.Optional;

public class IBZMongoSimpleRepository<T extends EntityMongo, ID> extends SimpleMongoRepository<T, ID> implements IBZMongoRepository<T, ID> {

    private final MongoOperations mongoOperations;
    private final MongoEntityInformation<T, ID> entityInformation;

    public IBZMongoSimpleRepository(MongoEntityInformation<T, ID> metadata, MongoOperations mongoOperations) {
        super(metadata, mongoOperations);
        this.entityInformation = metadata;
        this.mongoOperations = mongoOperations;
    }

    @Override
    public <S extends T> S save(S entity) {
        //更新空值处理
        ID id = entityInformation.getId(entity);
        if (id != null) {
            Optional<T> op = findById(id);
            if (op.isPresent()) {
                T t = op.get();
                CachedBeanCopier.copyWithFocusNull(entity,t);
                entity = (S) t;
            }
        }
        return super.save(entity);
    }

    @Override
    public <S extends T> Page<T> query(MongoQueryContext mongoQueryContext) {
        Query query = mongoQueryContext.getSearchCond();
        query.with(mongoQueryContext.getPageable());
        if(mongoQueryContext.getPageSort()!=null)
            query.with(mongoQueryContext.getPageSort());
        List<T> list = mongoOperations.find(query, entityInformation.getJavaType(), entityInformation.getCollectionName());

        return PageableExecutionUtils.getPage(list, mongoQueryContext.getPageable(),
                () -> mongoOperations.count(query, entityInformation.getJavaType(), entityInformation.getCollectionName()));
    }
}
