package cn.ibizlab.util.domain;

import cn.ibizlab.util.helper.BeanCache;
import cn.ibizlab.util.helper.Setting;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;
import org.springframework.cglib.beans.BeanMap;
import org.springframework.data.annotation.Transient;
import org.springframework.util.ObjectUtils;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@Data
public class DTOBase implements Serializable {


    @JsonIgnore
    @JSONField(serialize = false)
    private Set<String> focusNull;


    public void modify(String field,Object val) {
        if(val==null) {
            this.getFocusNull(true).add(field.toLowerCase());
        }
        else {
            this.getFocusNull(true).remove(field.toLowerCase());
        }
    }

    @JsonIgnore
    @JSONField(serialize = false)
    public Set<String> getFocusNull() {
        if(focusNull==null) {
            focusNull=new HashSet<>();
        }
        if(focusNull.size()>0 && extensionparams.containsKey("dirtyflagenable"))
        {
            Set<String> nocheck=new HashSet<>();
            for(String key:focusNull)
            {
                if(!extensionparams.containsKey(key+"dirtyflag")) {
                    nocheck.add(key);
                }
            }
            for(String key:nocheck) {
                focusNull.remove(key);
            }
        }
        return focusNull;
    }

    private Set<String> getFocusNull(boolean newflag) {
        if(focusNull==null) {
            focusNull=new HashSet<>();
        }
        return focusNull;
    }

    @JsonIgnore
    @JSONField(serialize = false)
    private Map<String,Object> extensionparams=new HashMap<String,Object>();

    @JsonIgnore
    @JSONField(serialize = false)
    public Map<String, Object> getExtensionparams() {
        return extensionparams;
    }

    public void setExtensionparams(Map<String, Object> extensionparams) {
        this.extensionparams = extensionparams;
    }

    @JsonAnyGetter
    @JSONField(name = "_any", unwrapped = true, serialize = true, deserialize = false)
    public Map<String , Object> any() {
        return extensionparams;
    }

    @JsonIgnore
    @JSONField(serialize = false)
    @Transient
    private BeanMap map;

    @JsonIgnore
    @JSONField(serialize = false)
    @Transient
    private BeanMap getMap()
    {
        if(map==null) {
            map=BeanMap.create(this);
        }
        return  map;
    }

    public Object get(String field) {
        String fieldRealName= BeanCache.getFieldRealName(this.getClass(),field);
        if(!ObjectUtils.isEmpty(fieldRealName)) {
            return getMap().get(fieldRealName);
        }
        else {
            return this.extensionparams.get(field.toLowerCase());
        }
    }

    @JsonAnySetter
    @JSONField(name = "_any", unwrapped = true, serialize = false, deserialize = true)
    public void set(String field, Object value) {
        field=field.toLowerCase();
        String fieldRealName=BeanCache.getFieldRealName(this.getClass(),field);
        if(!ObjectUtils.isEmpty(fieldRealName)) {
            if (value == null) {
                getMap().put(fieldRealName, null);
            }
            else {
                getMap().put(fieldRealName, BeanCache.fieldValueOf(this.getClass(), fieldRealName, value));
            }
        }
        else {
            this.extensionparams.put(field.toLowerCase(),value);
        }
    }

    public void readSetting(String field)
    {
        Object config=this.get(field);
        if(!ObjectUtils.isEmpty(config))
        {
            Setting.getMap(config.toString()).entrySet().forEach(entry->{
                this.set(entry.getKey(),entry.getValue());
            });
        }
    }
}

