package cn.ibizlab.util.service;

import cn.ibizlab.util.client.IBZUAAFeignClient;
import cn.ibizlab.util.errors.BadRequestAlertException;
import cn.ibizlab.util.security.AuthenticationInfo;
import cn.ibizlab.util.security.AuthenticationUser;
import cn.ibizlab.util.security.AuthorizationLogin;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

/**
 * 实体[IBZUSER] 服务对象接口实现
 */
@Service("IBZUAAUserService")
@ConditionalOnExpression("'${ibiz.auth.service:IBZUAAUserService}'.equals('IBZUAAUserService')")
public class IBZUAAUserService implements AuthenticationUserService{

	@Autowired
	private IBZUAAFeignClient uaaFeignClient;


	@Value("${ibiz.enablePermissionValid:false}")
	boolean enablePermissionValid;  //是否开启权限校验

	@Value("${ibiz.systemid}")
	private String systemId;

	@Override
	public boolean isEnablePermissionValid() {
		return enablePermissionValid;
	}

	@Override
	public String getSystemId() {
		return systemId;
	}

	@Override
	@Cacheable( value="ibzuaa_users", key = "#root.target.systemId+':getByUsername:'+#p0")
	public AuthenticationUser loadUserByUsername(String username) {
		AuthenticationUser user = uaaFeignClient.loginByUsername(username);
		if(user == null) {
			throw new BadRequestAlertException("登录失败","IBZUAAUser",username);
		}
		return user;
	}

	@Override
	public AuthenticationInfo loadUserByLogin(String username, String password) {
		String[] data = username.split("[|]");
		String loginname = username;
		String domains = "";

		if(data.length==2) {
			loginname=data[0].trim();
			domains=data[1].trim();
		}
		AuthorizationLogin logininfo = new AuthorizationLogin();
		logininfo.setDomain(domains);
		logininfo.setLoginname(loginname);
		logininfo.setPassword(password);
		AuthenticationInfo info = uaaFeignClient.v7Login(logininfo);
		if(info.getUser() == null){
			throw new BadRequestAlertException("登录失败","IBZUAAUser", username);
		}
		return info;
	}

	@Override
	@CacheEvict( value="ibzuaa_users", key = "'glob:*getByUsername:'+#p0")
	public void resetByUsername(String username) {
	}
}
