package cn.ibizlab.util.security;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Data;

import java.io.Serializable;

@Data
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class UAAUniResAuthority extends UAAGrantedAuthority {

    private String unionResTag;

    public UAAUniResAuthority(){
        this.setType("UNIRES");
    }

    @Override
    public String getAuthority() {
        return unionResTag==null||unionResTag.startsWith("UNIRES_")?unionResTag:("UNIRES_"+unionResTag);
    }

    public void setAuthority(String unionResTag) {
        this.unionResTag = unionResTag;
    }

}

