package cn.ibizlab.util.security;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Data;

@Data
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class UAAMenuAuthority extends UAAGrantedAuthority {

    private String menuTag;

    public UAAMenuAuthority(){
        this.setType("APPMENU");
    }

    @Override
    public String getAuthority() {
        return menuTag==null||menuTag.startsWith("APPMENU_")?menuTag:("APPMENU_"+menuTag);
    }

    public void setAuthority(String menuTag) {
        this.menuTag = menuTag;
    }

}

