package cn.ibizlab.util.service;


import cn.ibizlab.util.security.AuthenticationUser;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.security.core.userdetails.UserDetailsService;


public interface AuthenticationUserService extends UserDetailsService {


    @Override
    @Cacheable( value="ibzuaa_users", key = "'getByUsername:'+#p0")
    default AuthenticationUser loadUserByUsername(String username){
        return null ;
    }


    @Cacheable( value="ibzuaa_users", key = "'getByUsername:'+#p0")
    AuthenticationUser loadUserByLogin(String username, String password);

    @CacheEvict( value="ibzuaa_users", key = "'glob:*getByUsername:'+#p0")
    default void resetByUsername(String username){}


}
