<#--  BEGIN：获取父关系路由参数  -->
<#macro getDeResParameters currentView>
  <#if currentView.isPSDEView()>
    [<#t>
    <#if currentView.getPSAppDERSPathCount() gt 0>
      <#list currentView.getPSAppDERSPath(currentView.getPSAppDERSPathCount() - 1) as deRSPath>
      <#assign majorPSAppDataEntity = deRSPath.getMajorPSAppDataEntity()/><#t>
        { pathName: '${srfpluralize(majorPSAppDataEntity.codeName)?lower_case}', parameterName: '${majorPSAppDataEntity.getCodeName()?lower_case}' }, <#t>
      </#list>
    </#if>
    ]<#t>
  <#else>
    []<#t>
  </#if>
</#macro>
<#--  END：获取父关系路由参数  -->

<#--  BEGIN：获取视图本身路由参数  -->
<#macro getParameters currentView>
  [<#t>
  <#if currentView.isPSDEView()>
    <#assign appDataEntity = currentView.getPSAppDataEntity()/>
    { pathName: '${srfpluralize(appDataEntity.codeName)?lower_case}', parameterName: '${appDataEntity.getCodeName()?lower_case}' }, <#t>
    { pathName: '${currentView.getPSDEViewCodeName()?lower_case}', parameterName: '${currentView.getPSDEViewCodeName()?lower_case}' } <#t>
  <#else>
    { pathName: '${currentView.getCodeName()?lower_case}', parameterName: '${currentView.getCodeName()?lower_case}' } <#t>
  </#if>
  ]<#t>
</#macro>
<#--  END：获取视图本身路由参数  -->

<#--  BEGIN：获取选择界面视图参数  -->
<#macro getPickupView currentItem>
  <#if currentItem.getPickupPSAppView()??>
    <#assign pickupview=currentItem.getPickupPSAppView()>
    "{ <#t>
      viewname: '${srffilepath2(pickupview.codeName)}'<#t>
    <#if pickupview.isPSDEView()>
      , title: $t('entities.${pickupview.getPSAppDataEntity().getCodeName()?lower_case}.views.${pickupview.getPSDEViewCodeName()?lower_case}.title')<#t>
    <#else>
      , title: $t('app.views.${pickupview.getCodeName()?lower_case}.title')<#t>
    </#if>
      , deResParameters: <@getDeResParameters pickupview /><#t>
      , parameters: <@getParameters pickupview /><#t>
    <#if (pickupview.getWidth() gt 0)>
      , width: ${pickupview.getWidth()?c}<#t>
    </#if>
    <#if (pickupview.getHeight() gt 0)>
      , height: ${pickupview.getHeight()?c}<#t>
    </#if>
    <#if  pickupview.getOpenMode()??>
      , placement:'${pickupview.getOpenMode()}'<#t>
    </#if>
    <#t> }"
  <#else><#t>
    "{}"<#t>
  </#if>
</#macro>
<#--  END：获取选择界面视图参数  -->

<#--  BEGIN：获取数据链接视图参数  -->
<#macro getLinkView currentItem>
  <#if currentItem.getLinkPSAppView()??>
    <#assign linkview=currentItem.getLinkPSAppView()>
    "{ <#t>
    viewname: '${linkview.codeName}'<#t>
    <#if linkview.isPSDEView()>
    , title: $t('entities.${linkview.getPSAppDataEntity().getCodeName()?lower_case}.views.${linkview.getPSDEViewCodeName()?lower_case}.title')<#t>
    <#else>
    , title: $t('app.views.${linkview.getCodeName()?lower_case}.title')<#t>
    </#if>
    , deResParameters: <@getDeResParameters linkview /><#t>
    , parameters: <@getParameters linkview /><#t>
    , width: ${linkview.getWidth()?c}<#t>
    , height: ${linkview.getHeight()?c}<#t>
    , placement: '${linkview.getOpenMode()}'<#t>
    , isRedirectView: <#t>
    <#if linkview.isRedirectView()>
      true<#t>
      <#assign link_de = linkview.getPSAppDataEntity().getPSDataEntity()/>
      , url: '/${app.getPKGCodeName()?lower_case}/${link_de.getPSSystemModule().codeName?lower_case}/${link_de.codeName?lower_case}/${linkview.getPSDEViewCodeName()?lower_case}/getmodel'<#t>
    <#else><#t>
      false<#t>
    </#if>
    <#t> }"
  <#else><#t>
    "{}"<#t>
  </#if>
</#macro>
<#--  END：获取数据链接视图参数  -->

<#--  BEGIN：获取自定义AC模板  -->
<#macro getItemRender currentItem>
  <#if currentItem.itemRender??>
    <template v-slot:default="{item}"><#t>
        ${currentItem.itemRender.code}<#t>
    </template><#t>
  </#if>
</#macro>
<#--  END：获取自定义AC模板  -->

<#--  BEGIN：获取AC参数  -->
<#macro getAcParams currentItem>
  "{ <#t>
  <#if currentItem.getPSAppDataEntity?? && currentItem.getPSAppDataEntity()?? && currentItem.getPSAppDEDataSet?? && currentItem.getPSAppDEDataSet()??>
    <#assign _appde = currentItem.getPSAppDataEntity()/>
    <#assign deDataSet = currentItem.getPSAppDEDataSet()/>
    <#if !P.exists("importService3", _appde.getId() + deDataSet.getCodeName(), "")>
      serviceName: '${srfclassname('${_appde.getCodeName()}')}Service'<#t>
      , interfaceName: '${deDataSet.getCodeName()}'<#t>
    </#if>
  </#if>
  }"<#t>
</#macro>
<#--  END：获取AC参数  -->

<#--  BEGIN：获取AC参数  -->
<#macro getItemParams currentItem>
  '{ <#t>
  <#if currentItem.getContextJOString?? && currentItem.getContextJOString()??>
    context:${editor.getContextJOString()},<#t>
  </#if>
  <#if currentItem.getParamJOString?? && currentItem.getParamJOString()??>
    param:${editor.getParamJOString()},<#t>
  </#if>
  }' <#t>
</#macro>
<#--  END：获取AC参数  -->

<#--  BEGIN：获取导航上下文  -->
<#macro getNavigateContext currentItem>
  '{ <#t>
  <#if currentItem.getPSNavigateContexts?? && currentItem.getPSNavigateContexts()??>
  <#list currentItem.getPSNavigateContexts() as navContext>
  ${navContext.getKey()}:<#if navContext.isRawValue()?? && navContext.isRawValue() == true>"${navContext.getValue()}"<#else>"%${navContext.getValue()}%"</#if><#if navContext_has_next>,</#if> <#t>
  </#list>
  </#if>
  }' <#t>
</#macro>
<#--  END：获取导航上下文  -->

<#--  BEGIN：获取导航参数  -->
<#macro getNavigateParams currentItem>
  '{ <#t>
  <#if currentItem.getPSNavigateParams?? && currentItem.getPSNavigateParams()??>
  <#list currentItem.getPSNavigateParams() as navParam >
  ${navParam.getKey()}:<#if navParam.isRawValue()?? && navParam.isRawValue() == true>"${navParam.getValue()}"<#else>"%${navParam.getValue()}%"</#if><#if navParam_has_next>,</#if> <#t>
  </#list>
  </#if>
  }' <#t>
</#macro>
<#--  END：获取导航参数  -->
