<script lang='tsx'>
import { Vue, Component, Prop, Provide, Emit, Watch,Inject } from 'vue-property-decorator';
import { UIActionTool,Util } from '@/utils';
import NavDataService from '@/service/app/navdata-service';
<#if view.getPSAppCounterRefs()??>
<#list view.getPSAppCounterRefs() as singleCounterRef>
<#if singleCounterRef.getPSAppCounter()??>
<#assign appCounter = singleCounterRef.getPSAppCounter()/>
import  ${srfclassname('${appCounter.getCodeName()}')}CounterService  from '@/counter/${srffilepath2(appCounter.getCodeName())}/${srffilepath2(appCounter.getCodeName())}-counter';
</#if>
</#list>
</#if>
import { Subject,Subscription } from 'rxjs';
<#if view.getPSAppDataEntity?? && view.getPSAppDataEntity()??>
<#assign appde = view.getPSAppDataEntity()/>
import ${srfclassname('${appde.getCodeName()}')}Service from '@/service/${srffilepath2(appde.getCodeName())}/${srffilepath2(appde.getCodeName())}-service';
import ${srfclassname('${appde.getCodeName()}')}AuthService from '@/authservice/${srffilepath2(appde.getCodeName())}/${srffilepath2(appde.getCodeName())}-auth-service';
</#if>

<#if view.getPSAppViewEngines()??>
<#list view.getPSAppViewEngines() as engine>
import ${engine.getEngineType()}Engine from '@engine/${engine.getEngineCat()?lower_case}/${srffilepath2(engine.getEngineType())}-engine';
</#list>
</#if>


<#if view.getPSUIActions()??>
<#list view.getPSUIActions() as uiAction>
<#if uiAction.getPSAppDataEntity?? && uiAction.getPSAppDataEntity()??>
<#if uiAction.getPFLogicCodeType() == "WFBACKEND">
<#if uiAction.getPSAppWFVer?? && uiAction.getPSAppWFVer()??>
<#if !P.exists("importService", uiAction.getPSAppWFVer().getCodeName(), "")>
import ${srfclassname('${uiAction.getPSAppWFVer().getCodeName()}')}WFUIService from '@/wfuiservice/${uiAction.getPSAppWF().getCodeName()?lower_case}/${uiAction.getPSAppWFVer().getCodeName()?lower_case}-ui-service';
</#if>
</#if>
</#if>
</#if>
</#list>
</#if>
<#if appde??>
import ${srfclassname('${appde.getCodeName()}')}UIService from '@/uiservice/${srffilepath2(appde.getCodeName())}/${srffilepath2(appde.getCodeName())}-ui-service';
</#if>
<#if import_block??>
${import_block}
</#if>

@Component({
    components: {
    },
})
export default class ${srfclassname('${view.name}')}Base extends Vue {
<#if view.getPSAppDataEntity?? && view.getPSAppDataEntity()??>
<#assign appde = view.getPSAppDataEntity()/>

    /**
     * 实体服务对象
     *
     * @type {${srfclassname('${appde.getCodeName()}')}Service}
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public appEntityService: ${srfclassname('${appde.getCodeName()}')}Service = new ${srfclassname('${appde.getCodeName()}')}Service;

    /**
     * 实体UI服务对象
     *
     * @type ${srfclassname('${appde.getCodeName()}')}UIService
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public appUIService: ${srfclassname('${appde.getCodeName()}')}UIService = new ${srfclassname('${appde.getCodeName()}')}UIService(this.$store);
</#if>

<#if view.getPSAppCounterRefs()??>
<#assign counterRefs = ''/>
<#list view.getPSAppCounterRefs() as singleCounterRef>
<#if singleCounterRef.getPSAppCounter()??>
<#assign appCounter = singleCounterRef.getPSAppCounter()/>
<#assign counterRefs>${counterRefs}this.${srfclassname('${appCounter.getCodeName()}')}counterservice<#if singleCounterRef_has_next>,</#if></#assign>

    /**
     * ${srfclassname('${appCounter.getCodeName()}')}CounterService计数器服务对象
     *
     * @type {${srfclassname('${appCounter.getCodeName()}')}CounterService}
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public ${srfclassname('${appCounter.getCodeName()}')}counterservice: ${srfclassname('${appCounter.getCodeName()}')}CounterService = new ${srfclassname('${appCounter.getCodeName()}')}CounterService({ $store: this.$store });
</#if>
</#list>

    /**
     * 计数器服务对象集合
     *
     * @type {Array<*>}
     * @memberof ${srfclassname('${view.name}')}Base
     */    
    public counterServiceArray:Array<any> = [${counterRefs}];
</#if>
    
    /**
     * 数据变化
     *
     * @param {*} val
     * @returns {*}
     * @memberof ${srfclassname('${view.name}')}Base
     */
    @Emit() 
    public viewDatasChange(val: any):any {
        return val;
    }

    /**
     * 传入视图上下文
     *
     * @type {string}
     * @memberof ${srfclassname('${view.name}')}Base
     */
    @Prop() public viewdata!: string;

    /**
     * 传入视图参数
     *
     * @type {string}
     * @memberof ${srfclassname('${view.name}')}Base
     */
    @Prop() public viewparam!: string;

    /**
     * 视图默认使用
     *
     * @type {boolean}
     * @memberof ${srfclassname('${view.name}')}Base
     */
    @Prop({ default: true }) public viewDefaultUsage!: boolean;

    <#if view.getViewType() != "APPINDEXVIEW">
    /**
     * 视图默认使用
     *
     * @type {string}
     * @memberof ${srfclassname('${view.name}')}Base
     */
    @Inject({from:'navModel',default: 'tab'})
    public navModel!:string;
    </#if>

	/**
	 * 视图标识
	 *
	 * @type {string}
	 * @memberof ${srfclassname('${view.name}')}Base
	 */
	public viewtag: string = '${view.getId()}';

	/**
	 * 自定义视图导航上下文集合
	 *
	 * @type {*}
	 * @memberof ${srfclassname('${view.name}')}Base
	 */
    public customViewNavContexts:any ={
    <#if view.getPSAppViewNavContexts()??>
    <#list view.getPSAppViewNavContexts() as viewNavContext>
    "${viewNavContext.getKey()}":{"isRawValue":${viewNavContext.isRawValue()?c},"value":"${viewNavContext.getValue()}"}<#if viewNavContext_has_next>,</#if>
    </#list>
    </#if>
    };

	/**
	 * 自定义视图导航参数集合
	 *
	 * @type {*}
	 * @memberof ${srfclassname('${view.name}')}Base
	 */
    public customViewParams:any ={
    <#if view.getPSAppViewNavParams()??>
    <#list view.getPSAppViewNavParams() as viewNavParam>
    "${viewNavParam.getKey()}":{"isRawValue":${viewNavParam.isRawValue()?c},"value":"${viewNavParam.getValue()}"}<#if viewNavParam_has_next>,</#if>
    </#list>
    </#if>
    };

    /**
     * 视图模型数据
     *
     * @type {*}
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public model: any = {
        srfCaption: '<#if view.getPSAppDataEntity()??>entities.${view.getPSAppDataEntity().getCodeName()?lower_case}.views.${view.getPSDEViewCodeName()?lower_case}.caption<#else>app.views.${view.getCodeName()?lower_case}.caption</#if>',
        srfTitle: '<#if view.getPSAppDataEntity()??>entities.${view.getPSAppDataEntity().getCodeName()?lower_case}.views.${view.getPSDEViewCodeName()?lower_case}.title<#else>app.views.${view.getCodeName()?lower_case}.title</#if>',
        srfSubTitle: '<#if view.getPSAppDataEntity()??>entities.${view.getPSAppDataEntity().getCodeName()?lower_case}.views.${view.getPSDEViewCodeName()?lower_case}.subtitle<#else>app.views.${view.getCodeName()?lower_case}.subtitle</#if>',
        dataInfo: ''
    }

    /**
     * 视图参数变化
     *
     * @param {*} newVal
     * @param {*} oldVal
     * @memberof ${srfclassname('${view.name}')}Base
     */
    @Watch('viewparam',{immediate: true, deep: true})
    onParamData(newVal: any, oldVal: any) {
        if(newVal){
            for(let key in this.viewparams){
                delete this.viewparams[key];
            }
            Object.assign(this.viewparams, JSON.parse(this.viewparam));
            <#if watch_viewparam_block??>${watch_viewparam_block}</#if>
        } 
    }

    /**
     * 处理应用上下文变化
     *
     * @param {*} newVal
     * @param {*} oldVal
     * @memberof ${srfclassname('${view.name}')}Base
     */
    @Watch('viewdata')
    onViewData(newVal: any, oldVal: any) {
        const _this: any = this;
        if (!Object.is(newVal, oldVal) && _this.engine) {
            this.$nextTick(()=>{
              _this.parseViewParam();
              _this.engine.load();
              <#if viewdata_block??>${viewdata_block}</#if>
            });
        }
    }

    /**
     * 容器模型
     *
     * @type {*}
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public containerModel: any = {
        <#if view.getPSControls()??>
        <#list view.getPSControls() as ctrl>
        view_${ctrl.name}: { name: '${ctrl.name}', type: '${ctrl.getControlType()}' },
        </#list>
        </#if>
        <#if view.isPickupView() || (view.getViewType?? && (view.getViewType() == 'DEOPTVIEW' || view.getViewType() == 'DEWFSTARTVIEW' || view.getViewType() == 'DEWFACTIONVIEW'))>
        view_okbtn: { name: 'okbtn', type: 'button', text: '确定', disabled: true },
        view_cancelbtn: { name: 'cancelbtn', type: 'button', text: '取消', disabled: false },
        view_leftbtn: { name: 'leftbtn', type: 'button', text: '左移', disabled: true },
        view_rightbtn: { name: 'rightbtn', type: 'button', text: '右移', disabled: true },
        view_allleftbtn: { name: 'allleftbtn', type: 'button', text: '全部左移', disabled: true },
        view_allrightbtn: { name: 'allrightbtn', type: 'button', text: '全部右移', disabled: true },
        </#if>
        <#if view.getPSWorkflow?? && view.getPSWorkflow()??>
        wflinks: [],
        </#if>
    };

    /**
     *  计数器刷新
     *
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public counterRefresh(){
        const _this:any =this;
        if(_this.counterServiceArray && _this.counterServiceArray.length >0){
            _this.counterServiceArray.forEach((item:any) =>{
                if(item.refreshData && item.refreshData instanceof Function){
                    item.refreshData();
                }
            })
        }
    }

    /**
     * 视图状态订阅对象
     *
     * @public
     * @type {Subject<{action: string, data: any}>}
     * @memberof ${srfclassname('${view.name}')}Base
     */
    public viewState: Subject<ViewState> = new Subject();
<#if view.hasPSControl('toolbar')>
${P.getCtrlCode('toolbar', 'CONTROL.vue').code}
</#if>